unit cxDBTRichView;

interface

{$I cxVer.inc}
{$I RV_Defs.inc}

uses
  Windows, Messages,
  {$IFDEF DELPHI6}
  Variants,
  {$ENDIF}
  Classes, Clipbrd, Controls, Forms, Graphics, Menus, StdCtrls, SysUtils,
  cxClasses,
  cxContainer, cxControls, cxDataUtils, cxEdit, cxDrawTextUtils, cxFormats,
  cxGraphics, cxVariants, dxCore, cxDBEdit, ImgList,
  {$IFNDEF RVDONOTUSESMARTPOPUP}
  RVPopup,
  {$ENDIF}
  {$IFNDEF RVDONOTUSEDOCPARAMS}
  RVDocParams,
  {$ENDIF}
  RVClasses, RVTypes, RVScroll, RichView, RVEdit, RVStyle, RVRTFProps, RVStr,
  RVItem, CRVData, CRVFData, RVReport,
  cxTRichView;

type
  TcxDBRVDataBinding = class(TcxDBEditDataBinding)
  protected
    procedure SetDisplayValue(const Value: TcxEditValue); override;
    procedure UpdateData; override;
  public
    procedure UpdateNotConnectedDBEditDisplayValue; override;
  end;

  {$IFDEF RICHVIEWDEFXE2}
  [ComponentPlatformsAttribute(pidWin32 or pidWin64)]
  {$ENDIF}

  TcxDBTRichViewEdit = class(TcxCustomTRichViewEdit)
  private
    function GetActiveProperties: TcxRVProperties;
    function GetProperties: TcxRVProperties;
    procedure SetProperties(Value: TcxRVProperties);
    function GetDataBinding: TcxDBRVDataBinding;
    procedure SetDataBinding(const Value: TcxDBRVDataBinding);
    procedure CMGetDataLink(var Message: TMessage); message CM_GETDATALINK;
  protected
    class function GetDataBindingClass: TcxEditDataBindingClass; override;
  public
    class function GetPropertiesClass: TcxCustomEditPropertiesClass; override;
    property ActiveProperties: TcxRVProperties read GetActiveProperties;
  published
    property Align;
    property Anchors;
    property AutoSize;
    property Constraints;
    property DataBinding: TcxDBRVDataBinding read GetDataBinding
      write SetDataBinding;
    property DragCursor;
    property DragKind;
    property DragMode;
    property Enabled;
    property ParentColor;
    property ParentShowHint;
    property PopupMenu;
    property Properties: TcxRVProperties read GetProperties write SetProperties;
    property ShowHint;
    property Style;
    property StyleDisabled;
    property StyleFocused;
    property StyleHot;
    property TabOrder;
    property TabStop;
    property Transparent;
    property Visible;
    property OnClick;
    property OnContextPopup;
    property OnDblClick;
    property OnDragDrop;
    property OnDragOver;
    property OnEditing;
    property OnEndDock;
    property OnEndDrag;
    property OnEnter;
    property OnExit;
    property OnKeyDown;
    property OnKeyPress;
    property OnKeyUp;
    property OnMouseDown;
    property OnMouseMove;
    property OnMouseUp;
    property OnStartDock;
    property OnStartDrag;
  end;

implementation

{================================ TcxDBTRichViewEdit ==========================}
procedure TcxDBTRichViewEdit.CMGetDataLink(var Message: TMessage);
begin
  Message.Result := Integer(GetcxDBEditDataLink(Self));
end;

{------------------------------------------------------------------------------}
function TcxDBTRichViewEdit.GetActiveProperties: TcxRVProperties;
begin
  Result := TcxRVProperties(InternalGetActiveProperties);
end;

{------------------------------------------------------------------------------}
function TcxDBTRichViewEdit.GetDataBinding: TcxDBRVDataBinding;
begin
  Result := FDataBinding as TcxDBRVDataBinding;
end;

{------------------------------------------------------------------------------}
class function TcxDBTRichViewEdit.GetDataBindingClass: TcxEditDataBindingClass;
begin
  Result := TcxDBRVDataBinding;
end;

{------------------------------------------------------------------------------}
function TcxDBTRichViewEdit.GetProperties: TcxRVProperties;
begin
  Result := TcxRVProperties(FProperties);
end;

{------------------------------------------------------------------------------}
class function TcxDBTRichViewEdit.GetPropertiesClass
  : TcxCustomEditPropertiesClass;
begin
  Result := TcxRVProperties;
end;

{------------------------------------------------------------------------------}
procedure TcxDBTRichViewEdit.SetDataBinding(const Value: TcxDBRVDataBinding);
begin
  FDataBinding.Assign(Value);
end;

{------------------------------------------------------------------------------}
procedure TcxDBTRichViewEdit.SetProperties(Value: TcxRVProperties);
begin
  FProperties.Assign(Value);
end;

{============================== TcxDBRVDataBinding ============================}
procedure TcxDBRVDataBinding.SetDisplayValue(const Value: TcxEditValue);
begin
  if IsDataAvailable then
    SetInternalDisplayValue(Value)
  else if Edit.IsDesigning then
    SetInternalDisplayValue(Edit.Name)
  else
    SetInternalDisplayValue('');
end;

{------------------------------------------------------------------------------}
procedure TcxDBRVDataBinding.UpdateData;
begin
  StoredValue := Edit.EditValue;
end;

{------------------------------------------------------------------------------}
procedure TcxDBRVDataBinding.UpdateNotConnectedDBEditDisplayValue;
begin
  if not IsDataAvailable then
  begin
    Edit.LockClick(True);
    try
      DisplayValue := '';
    finally
      Edit.LockClick(False);
    end;
  end;
end;

end.
