unit cxTRichView;

interface

{$I cxVer.inc}
{$I RV_Defs.inc}

uses
  Windows, Messages,
  {$IFDEF DELPHI6}
  Variants,
  {$ENDIF}
  Classes, Clipbrd, Controls, Forms, Graphics, Menus, StdCtrls, SysUtils,
  cxClasses,
  cxContainer, cxControls, cxDataUtils, cxEdit, cxDrawTextUtils, cxFormats,
  cxGraphics, cxVariants, dxCore, ImgList, dxCoreClasses, cxLookAndFeelPainters,
  cxScrollBar,
  {$IFDEF RICHVIEWDEFXE2}
  UITypes,
  {$ENDIF}
  {$IFDEF RICHVIEWDEF10}
  Types,
  {$ENDIF}
  {$IFNDEF RVDONOTUSESMARTPOPUP}
  RVPopup,
  {$ENDIF}
  {$IFNDEF RVDONOTUSEDOCPARAMS}
  RVDocParams,
  {$ENDIF}
  RVClasses, RVTypes, RVScroll, RichView, RVEdit, RVStyle, RVRTFProps, RVStr,
  RVItem, CRVData, CRVFData, RVReport, RVRVData, RVERVData;

type
  TcxRVEditValueFormat = (cxrvvfAnsiText, cxrvvfUnicodeText, cxrvvfRTF,
    cxrvvfRVF);

  TcxCustomTRichViewEdit = class;
  TcxTRichViewEdit = class;
  TcxInnerTRichViewEdit = class;
  TcxCustomRVProperties = class;

  TcxRVViewInfo = class(TcxCustomEditViewInfo)
  private
    FReportHelper:                  TRVReportHelper;
    FUseDocColor, FUseDocFontColor: Boolean;
    procedure InitReportHelper;
  protected
    procedure InternalPaint(ACanvas: TcxCanvas); override;
  public
    destructor Destroy; override;
  end;

  TcxRVViewData = class(TcxCustomEditViewData)
  public
    procedure Calculate(ACanvas: TcxCanvas; const ABounds: TRect;
      const P: TPoint; Button: TcxMouseButton; Shift: TShiftState;
      AViewInfo: TcxCustomEditViewInfo; AIsMouseEvent: Boolean); override;
    procedure EditValueToDrawValue(const AEditValue: TcxEditValue;
      AViewInfo: TcxCustomEditViewInfo); override;
    function GetEditContentSize(ACanvas: TcxCanvas;
      const AEditValue: TcxEditValue;
      const AEditSizeProperties: TcxEditSizeProperties;
      AErrorData: TcxEditValidateInfo): TSize; override;
    function GetClientExtent(ACanvas: TcxCanvas;
      AViewInfo: TcxCustomEditViewInfo): TRect; override;
  end;

  TcxRVRTFReaderProperties = class(TRVRTFReaderProperties)
  private
    FOwner: TcxCustomRVProperties;
  protected
    procedure Changed; override;
  public
    constructor Create(AOwner: TcxCustomRVProperties); reintroduce;
  published
    property TextStyleMode default rvrsAddIfNeeded;
    property ParaStyleMode default rvrsAddIfNeeded;
    property UnicodeMode default rvruOnlyUnicode;
  end;

  TcxRVDefFont = class(TFont)
  private
    FOwner: TcxCustomRVProperties;
  protected
    procedure Changed; override;
  public
    constructor Create(AOwner: TcxCustomRVProperties);
  end;

  TcxCustomRVProperties = class(TcxCustomEditProperties)
  private
    FVAlign:              TTextLayout;
    FScrollBars:          TScrollStyle;
    FEditValueSaveFormat: TcxRVEditValueFormat;
    {$IFNDEF RVDONOTUSELIVESPELL}
    FOnSpellingCheck: TRVSpellingCheckEvent;
    {$ENDIF}
    FOnGetItemCursor:       TRVGetItemCursorEvent;
    FMaxLength:             Integer;
    FOnWriteHyperlink:      TRVWriteHyperlink;
    FOnJump:                TJumpEvent;
    FOnImportPicture:       TRVImportPictureEvent;
    FMaxTextWidth:          Integer;
    FDelimiters:            String;
    FOnSelect:              TNotifyEvent;
    FOnAddStyle:            TRVAddStyleEvent;
    FOnSaveItemToFile:      TRVSaveItemToFileEvent;
    FOnHTMLSaveImage:       TRVHTMLSaveImageEvent;
    FBottomMargin:          Integer;
    FOnRVDblClick:          TRVDblClickEvent;
    FRVFTextStylesReadMode: TRVFReaderStyleMode;
    {$IFNDEF RVDONOTUSESTYLETEMPLATES}
    FUseStyleTemplates:       Boolean;
    FStyleTemplateInsertMode: TRVStyleTemplateInsertMode;
    {$ENDIF}
    {$IFNDEF RVDONOTUSEANIMATION}
    FAnimationMode: TRVAnimationMode;
    {$ENDIF}
    FOnControlAction:       TRVControlActionEvent;
    FOnPaint:               TRVPaintEvent;
    FMinTextWidth:          Integer;
    FOnSaveRTFExtra:        TRVSaveRTFExtraEvent;
    FOnRVFPictureNeeded:    TRVFPictureNeededEvent;
    FOnItemAction:          TRVItemActionEvent;
    FTopMargin:             Integer;
    FOnSaveComponentToFile: TRVSaveComponentToFileEvent;
    FOnRVFImageListNeeded:  TRVFImageListNeededEvent;
    FLeftMargin:            Integer;
    FRVFParaStylesReadMode: TRVFReaderStyleMode;
    FOnSaveImage2:          TRVSaveImageEvent2;
    FOnRVMouseDown:         TRVMouseEvent;
    FOnRVFControlNeeded:    TRVFControlNeededEvent;
    FOnSaveHTMLExtra:       TRVSaveHTMLExtraEvent;
    FRVFOptions:            TRVFOptions;
    FOnRVMouseMove:         TRVMouseMoveEvent;
    FWordWrap:              Boolean;
    FRTFOptions:            TRVRTFOptions;
    FRightMargin:           Integer;
    FOptions:               TRVOptions;
    FOnProgress:            TRVProgressEvent;
    FOnItemHint:            TRVItemHintEvent;
    FBiDiMode:              TRVBiDiMode;
    FOnRVMouseUp:           TRVMouseEvent;
    FOnReadHyperlink:       TRVReadHyperlink;
    FOnCopy:                TNotifyEvent;
    FBackgroundStyle:       TBackgroundStyle;
    FBackBitmap:            TBitmap;
    FRTFReadProperties:     TcxRVRTFReaderProperties;
    FAcceptDragDropFormats: TRVDragDropFormats;
    FCustomCaretInterval:   Integer;
    FEditorOptions:         TRVEditorOptions;
    FUndoLimit:             Integer;
    FOnDropFiles:           TRVDropFilesEvent;
    FOnDrawCustomCaret:     TRVDrawCustomCaretEvent;
    FOnItemTextEdit:        TRVItemTextEditEvent;
    FOnStyleConversion:     TRVStyleConversionEvent;
    FOnCaretGetOut:         TRVOnCaretGetOutEvent;
    FOnCaretMove:           TNotifyEvent;
    FOnCurTextStyleChanged: TNotifyEvent;
    FOnParaStyleConversion: TRVStyleConversionEvent;
    FOnItemResize:          TRVItemResizeEvent;
    FOnMeasureCustomCaret:  TRVMeasureCustomCaretEvent;
    {$IFNDEF RVDONOTUSEDRAGDROP}
    {
     FOnOleDragEnter: TRVOleDragEnterEvent;
     FOnOleDragOver: TRVOleDragOverEvent;
     FOnOleDragLeave: TNotifyEvent;
     FOnOleDrop: TRVOleDropEvent;
    }
    {$ENDIF}
    FOnCurParaStyleChanged: TNotifyEvent;
    FVisibleLineCount:      Integer;
    FOnLoadValue:           TNotifyEvent;
    FUnicode:               Boolean;
    FDefFont:               TcxRVDefFont;
    {$IFNDEF RVDONOTUSEDOCPARAMS}
    // FDocParameters: TRVDocParameters;
    // function GetDocParameters: TRVDocParameters;
    // procedure SetDocParameters(const Value: TRVDocParameters);
    // function StoreDocParameters: Boolean;
    {$ENDIF}
    procedure SetScrollBars(Value: TScrollStyle);
    function GetRTFReadProperties: TcxRVRTFReaderProperties;
    {$IFNDEF RVDONOTUSESTYLETEMPLATES}
    procedure SetUseStyleTemplates(Value: Boolean);
    procedure SetStyleTemplateInsertMode(Value: TRVStyleTemplateInsertMode);
    {$ENDIF}
    {$IFNDEF RVDONOTUSEANIMATION}
    procedure SetAnimationMode(const Value: TRVAnimationMode);
    {$ENDIF}
    procedure SetBackBitmap(const Value: TBitmap);
    procedure SetBackgroundStyle(const Value: TBackgroundStyle);
    procedure SetBiDiModeRV(const Value: TRVBiDiMode);
    procedure SetBottomMargin(const Value: Integer);
    procedure SetDelimiters(const Value: String);
    procedure SetLeftMargin(const Value: Integer);
    procedure SetMaxLength(const Value: Integer);
    procedure SetMaxTextWidth(const Value: Integer);
    procedure SetMinTextWidth(const Value: Integer);
    procedure SetRightMargin(const Value: Integer);
    procedure SetRTFOptions(const Value: TRVRTFOptions);
    procedure SetRTFReadProperties(const Value: TcxRVRTFReaderProperties);
    procedure SetRVFParaStylesReadMode(const Value: TRVFReaderStyleMode);
    procedure SetRVFTextStylesReadMode(const Value: TRVFReaderStyleMode);
    procedure SetTopMargin(const Value: Integer);
    procedure SetVAlign(const Value: TTextLayout);
    function StoreDelimiters: Boolean;
    procedure SetRVFOptions(const Value: TRVFOptions);
    procedure SetWordWrap(const Value: Boolean);
    procedure SetAcceptDragDropFormats(const Value: TRVDragDropFormats);
    procedure SetCustomCaretInterval(const Value: Integer);
    procedure SetEditorOptions(const Value: TRVEditorOptions);
    procedure SetUndoLimit(const Value: Integer);
    function IsColorStoredInDoc: Boolean;
    function IsFontStoredInDoc: Boolean;
    procedure SetVisibleLineCount(Value: Integer);
    function GetBackBitmap: TBitmap;
    procedure AssignToTRichView(rv: TCustomRichView);
    procedure SetDefFont(const Value: TcxRVDefFont);
    procedure SetUnicode(const Value: Boolean);
  protected
    class function GetViewDataClass: TcxCustomEditViewDataClass; override;
    function HasDisplayValue: Boolean; override;
    function InnerEditNeedsTabs: Boolean; override;
  public
    constructor Create(AOwner: TPersistent); override;
    destructor Destroy; override;
    procedure Assign(Source: TPersistent); override;
    function GetSupportedOperations: TcxEditSupportedOperations; override;
    function GetEditValueSource(AEditFocused: Boolean)
      : TcxDataEditValueSource; override;
    class function GetViewInfoClass: TcxContainerViewInfoClass; override;
    class function GetContainerClass: TcxContainerClass; override;
    // new properties
    property Unicode: Boolean read FUnicode write SetUnicode default True;
    property DefFont: TcxRVDefFont read FDefFont write SetDefFont;
    property ScrollBars: TScrollStyle read FScrollBars write SetScrollBars
      default ssNone;
    property EditValueSaveFormat: TcxRVEditValueFormat read FEditValueSaveFormat
      write FEditValueSaveFormat default cxrvvfRVF;
    property VisibleLineCount: Integer read FVisibleLineCount
      write SetVisibleLineCount default 0;
    // new events
    property OnLoadValue: TNotifyEvent read FOnLoadValue write FOnLoadValue;
    // properties inherited from TRichView
    {$IFNDEF RVDONOTUSESTYLETEMPLATES}
    property UseStyleTemplates: Boolean read FUseStyleTemplates
      write SetUseStyleTemplates default False;
    property StyleTemplateInsertMode: TRVStyleTemplateInsertMode
      read FStyleTemplateInsertMode write SetStyleTemplateInsertMode
      default rvstimUseTargetFormatting;
    {$ENDIF}
    {$IFNDEF RVDONOTUSEANIMATION}
    property AnimationMode: TRVAnimationMode read FAnimationMode
      write SetAnimationMode default rvaniManualStart;
    {$ENDIF}
    property BackgroundBitmap: TBitmap read GetBackBitmap write SetBackBitmap;
    property BackgroundStyle: TBackgroundStyle read FBackgroundStyle
      write SetBackgroundStyle default bsNoBitmap;
    property BiDiMode: TRVBiDiMode read FBiDiMode write SetBiDiModeRV
      default rvbdUnspecified;
    property BottomMargin: Integer read FBottomMargin write SetBottomMargin
      default 5;
    property Delimiters: String read FDelimiters write SetDelimiters
      stored StoreDelimiters;
    {$IFNDEF RVDONOTUSEDOCPARAMS}
    // property DocParameters: TRVDocParameters read GetDocParameters write SetDocParameters stored StoreDocParameters;
    {$ENDIF}
    property LeftMargin: Integer read FLeftMargin write SetLeftMargin default 5;
    property MaxLength: Integer read FMaxLength write SetMaxLength default 0;
    property MaxTextWidth: Integer read FMaxTextWidth write SetMaxTextWidth
      default 0;
    property MinTextWidth: Integer read FMinTextWidth write SetMinTextWidth
      default 0;
    property Options: TRVOptions read FOptions write FOptions
      default [rvoAllowSelection, rvoScrollToEnd, rvoTagsArePChars,
    {$IFDEF RVUNICODEWINDOW}rvoAutoCopyUnicodeText, {$ELSE}rvoAutoCopyText,
    {$ENDIF}
    rvoAutoCopyImage, rvoAutoCopyRVF, rvoAutoCopyRTF, rvoDblClickSelectsWord,
      rvoRClickDeselects, rvoFormatInvalidate, rvoShowPageBreaks,
      rvoFastFormatting];
    property RightMargin: Integer read FRightMargin write SetRightMargin
      default 5;
    property RTFOptions: TRVRTFOptions read FRTFOptions write SetRTFOptions
      default [rvrtfDuplicateUnicode, rvrtfSaveEMFAsWMF, rvrtfSaveJpegAsJpeg];
    property RTFReadProperties: TcxRVRTFReaderProperties
      read GetRTFReadProperties write SetRTFReadProperties;
    property RVFOptions: TRVFOptions read FRVFOptions write SetRVFOptions
      default [rvfoSavePicturesBody, rvfoSaveControlsBody, rvfoSaveBinary,
      rvfoSaveDocProperties, rvfoLoadDocProperties, rvfoSaveTextStyles,
      rvfoSaveParaStyles, rvfoSaveBack, rvfoLoadBack, rvfoSaveLayout,
      rvfoLoadLayout];
    property RVFParaStylesReadMode: TRVFReaderStyleMode
      read FRVFParaStylesReadMode write SetRVFParaStylesReadMode
      default rvf_sInsertMerge;
    property RVFTextStylesReadMode: TRVFReaderStyleMode
      read FRVFTextStylesReadMode write SetRVFTextStylesReadMode
      default rvf_sInsertMerge;
    property TopMargin: Integer read FTopMargin write SetTopMargin default 5;
    property VAlign: TTextLayout read FVAlign write SetVAlign default tlTop;
    property WordWrap: Boolean read FWordWrap write SetWordWrap default True;
    // properties inherited from TRichViewEdit
    property AcceptDragDropFormats: TRVDragDropFormats
      read FAcceptDragDropFormats write SetAcceptDragDropFormats
      default [rvddRVF, rvddRTF, rvddText, rvddUnicodeText, rvddBitmap,
      rvddMetafile, rvddFiles];
    property CustomCaretInterval: Integer read FCustomCaretInterval
      write SetCustomCaretInterval default 0;
    property EditorOptions: TRVEditorOptions read FEditorOptions
      write SetEditorOptions default [rvoWantTabs, rvoCtrlJumps];
    property UndoLimit: Integer read FUndoLimit write SetUndoLimit default -1;
    // events inherited from TRichView
    property OnAddStyle: TRVAddStyleEvent read FOnAddStyle write FOnAddStyle;
    property OnControlAction: TRVControlActionEvent read FOnControlAction
      write FOnControlAction;
    property OnCopy: TNotifyEvent read FOnCopy write FOnCopy;
    property OnGetItemCursor: TRVGetItemCursorEvent read FOnGetItemCursor
      write FOnGetItemCursor;
    property OnImportPicture: TRVImportPictureEvent read FOnImportPicture
      write FOnImportPicture;
    property OnItemAction: TRVItemActionEvent read FOnItemAction
      write FOnItemAction;
    property OnItemHint: TRVItemHintEvent read FOnItemHint write FOnItemHint;
    property OnJump: TJumpEvent read FOnJump write FOnJump;
    property OnHTMLSaveImage: TRVHTMLSaveImageEvent read FOnHTMLSaveImage
      write FOnHTMLSaveImage;
    property OnPaint: TRVPaintEvent read FOnPaint write FOnPaint;
    property OnProgress: TRVProgressEvent read FOnProgress write FOnProgress;
    property OnReadHyperlink: TRVReadHyperlink read FOnReadHyperlink
      write FOnReadHyperlink;
    property OnRVDblClick: TRVDblClickEvent read FOnRVDblClick
      write FOnRVDblClick;
    property OnRVFImageListNeeded: TRVFImageListNeededEvent
      read FOnRVFImageListNeeded write FOnRVFImageListNeeded;
    property OnRVFControlNeeded: TRVFControlNeededEvent read FOnRVFControlNeeded
      write FOnRVFControlNeeded;
    property OnRVFPictureNeeded: TRVFPictureNeededEvent read FOnRVFPictureNeeded
      write FOnRVFPictureNeeded;
    property OnRVMouseDown: TRVMouseEvent read FOnRVMouseDown
      write FOnRVMouseDown;
    property OnRVMouseMove: TRVMouseMoveEvent read FOnRVMouseMove
      write FOnRVMouseMove;
    property OnRVMouseUp: TRVMouseEvent read FOnRVMouseUp write FOnRVMouseUp;
    property OnSaveComponentToFile: TRVSaveComponentToFileEvent
      read FOnSaveComponentToFile write FOnSaveComponentToFile;
    property OnSaveHTMLExtra: TRVSaveHTMLExtraEvent read FOnSaveHTMLExtra
      write FOnSaveHTMLExtra;
    property OnSaveImage2: TRVSaveImageEvent2 read FOnSaveImage2
      write FOnSaveImage2;
    property OnSaveItemToFile: TRVSaveItemToFileEvent read FOnSaveItemToFile
      write FOnSaveItemToFile;
    property OnSaveRTFExtra: TRVSaveRTFExtraEvent read FOnSaveRTFExtra
      write FOnSaveRTFExtra;
    property OnSelect: TNotifyEvent read FOnSelect write FOnSelect;
    {$IFNDEF RVDONOTUSELIVESPELL}
    property OnSpellingCheck: TRVSpellingCheckEvent read FOnSpellingCheck
      write FOnSpellingCheck;
    {$ENDIF}
    property OnWriteHyperlink: TRVWriteHyperlink read FOnWriteHyperlink
      write FOnWriteHyperlink;
    // events inherited from TRichViewEdit
    property OnCaretGetOut: TRVOnCaretGetOutEvent read FOnCaretGetOut
      write FOnCaretGetOut;
    property OnCaretMove: TNotifyEvent read FOnCaretMove write FOnCaretMove;
    property OnDropFiles: TRVDropFilesEvent read FOnDropFiles
      write FOnDropFiles;
    property OnParaStyleConversion: TRVStyleConversionEvent
      read FOnParaStyleConversion write FOnParaStyleConversion;
    property OnStyleConversion: TRVStyleConversionEvent read FOnStyleConversion
      write FOnStyleConversion;
    property OnCurParaStyleChanged: TNotifyEvent read FOnCurParaStyleChanged
      write FOnCurParaStyleChanged;
    property OnCurTextStyleChanged: TNotifyEvent read FOnCurTextStyleChanged
      write FOnCurTextStyleChanged;
    property OnItemTextEdit: TRVItemTextEditEvent read FOnItemTextEdit
      write FOnItemTextEdit;
    {$IFNDEF RVDONOTUSEDRAGDROP}
    {
     property OnOleDragEnter: TRVOleDragEnterEvent read FOnOleDragEnter write FOnOleDragEnter;
     property OnOleDragOver: TRVOleDragOverEvent read FOnOleDragOver write FOnOleDragOver;
     property OnOleDrop: TRVOleDropEvent read FOnOleDrop write FOnOleDrop;
     property OnOleDragLeave: TNotifyEvent read FOnOleDragLeave write FOnOleDragLeave;
    }
    {$ENDIF}
    property OnDrawCustomCaret: TRVDrawCustomCaretEvent read FOnDrawCustomCaret
      write FOnDrawCustomCaret;
    property OnMeasureCustomCaret: TRVMeasureCustomCaretEvent
      read FOnMeasureCustomCaret write FOnMeasureCustomCaret;
    property OnItemResize: TRVItemResizeEvent read FOnItemResize
      write FOnItemResize;
  end;

  TcxRVProperties = class(TcxCustomRVProperties)
  published
    property ReadOnly;
    // new properties
    property DefFont;
    property EditValueSaveFormat;
    property ScrollBars;
    property Unicode;
    property VisibleLineCount;
    // new events
    property OnLoadValue;
    // inherited events
    property OnChange;
    property OnEditValueChanged;
    // properties inherited from TRichView
    {$IFNDEF RVDONOTUSESTYLETEMPLATES}
    property UseStyleTemplates;
    property StyleTemplateInsertMode;
    {$ENDIF}
    {$IFNDEF RVDONOTUSEANIMATION}
    property AnimationMode;
    {$ENDIF}
    property BackgroundBitmap;
    property BackgroundStyle;
    property BiDiMode;
    property BottomMargin;
    property Delimiters;
    {$IFNDEF RVDONOTUSEDOCPARAMS}
    // property DocParameters: TRVDocParameters read GetDocParameters write SetDocParameters stored StoreDocParameters;
    {$ENDIF}
    property LeftMargin;
    property MaxLength;
    property MaxTextWidth;
    property MinTextWidth;
    property Options;
    property RightMargin;
    property RTFOptions;
    property RTFReadProperties;
    property RVFOptions;
    property RVFParaStylesReadMode;
    property RVFTextStylesReadMode;
    property TopMargin;
    property VAlign;
    property WordWrap;
    // properties inherited from TRichViewEdit
    property AcceptDragDropFormats;
    property CustomCaretInterval;
    property EditorOptions;
    property UndoLimit;
    // events inherited from TRichView
    property OnAddStyle;
    property OnControlAction;
    property OnCopy;
    property OnGetItemCursor;
    property OnImportPicture;
    property OnItemAction;
    property OnItemHint;
    property OnJump;
    property OnHTMLSaveImage;
    property OnPaint;
    property OnProgress;
    property OnReadHyperlink;
    property OnRVDblClick;
    property OnRVFImageListNeeded;
    property OnRVFControlNeeded;
    property OnRVFPictureNeeded;
    property OnRVMouseDown;
    property OnRVMouseMove;
    property OnRVMouseUp;
    property OnSaveComponentToFile;
    property OnSaveHTMLExtra;
    property OnSaveImage2;
    property OnSaveItemToFile;
    property OnSaveRTFExtra;
    property OnSelect;
    {$IFNDEF RVDONOTUSELIVESPELL}
    property OnSpellingCheck;
    {$ENDIF}
    property OnWriteHyperlink;
    // events inherited from TRichViewEdit
    property OnCaretGetOut;
    property OnCaretMove;
    property OnDropFiles;
    property OnParaStyleConversion;
    property OnStyleConversion;
    property OnCurParaStyleChanged;
    property OnCurTextStyleChanged;
    property OnItemTextEdit;
    {$IFNDEF RVDONOTUSEDRAGDROP}
    {
     property OnOleDragEnter;
     property OnOleDragOver;
     property OnOleDrop;
     property OnOleDragLeave;
    }
    {$ENDIF}
    property OnDrawCustomCaret;
    property OnMeasureCustomCaret;
    property OnItemResize;
  end;

  TcxRVEditHelper = class(TcxInterfacedPersistent, IcxContainerInnerControl,
    IcxCustomInnerEdit)
  private
    FAlignmentLock: Boolean;
    FEdit:          TcxInnerTRichViewEdit;
  protected
    property Edit: TcxInnerTRichViewEdit read FEdit;
  public
    constructor Create(AEdit: TcxInnerTRichViewEdit); reintroduce; virtual;

    // IcxContainerInnerControl
    function GetControlContainer: TcxContainer;
    function GetControl: TWinControl;

    // IcxCustomInnerEdit
    function CallDefWndProc(AMsg: UINT; WParam: WParam; LParam: LParam)
      : LRESULT;
    function GetEditValue: TcxEditValue;
    function GetOnChange: TNotifyEvent;
    procedure LockBounds(ALock: Boolean);
    procedure SafelySetFocus;
    procedure SetEditValue(const Value: TcxEditValue);
    procedure SetParent(Value: TWinControl);
    procedure SetOnChange(Value: TNotifyEvent);
    function GetReadOnly: Boolean;
    procedure SetReadOnly(Value: Boolean);
    function CanProcessClipboardMessages: Boolean;
  end;

  TcxRVData = class (TRVEditRVData)
  public
    function GetCxEditor: TcxCustomTRichViewEdit;
    function IsAssignedOnReadHyperlink: Boolean; override;
    function IsAssignedOnWriteHyperlink: Boolean; override;
    function IsAssignedOnProgress: Boolean; override;
    function IsAssignedOnCopy: Boolean; override;
  end;

  TcxInnerTRichViewEdit = class(TRichViewEdit, IUnknown,
    IcxContainerInnerControl, IcxInnerEditHelper)
  private
    FIsCreating:         Boolean;
    FHelper:             TcxRVEditHelper;
    FLockBoundsCount:    Integer;
    FUpdatingScrollbars: Boolean;
    procedure WMWindowPosChanged(var Message: TWMWindowPosChanged);
      message WM_WINDOWPOSCHANGED;
    procedure WMWindowPosChanging(var Message: TWMWindowPosChanging);
      message WM_WINDOWPOSCHANGING;
    procedure WMContextMenu(var Message: TMessage); message WM_CONTEXTMENU;
    function GetContainer: TcxCustomTRichViewEdit;
  protected
    procedure AfterHScroll; override;
    procedure AfterVScroll; override;
    procedure DoAfterResize; override;
    function GetDesignTimeText: String; override;
    procedure KeyDown(var Key: Word; Shift: TShiftState); override;
    procedure KeyUp(var Key: Word; Shift: TShiftState); override;
    procedure KeyPress(var Key: Char); override;
    procedure DblClick; override;
    procedure DragOver(Source: TObject; X, Y: Integer; State: TDragState;
      var Accept: Boolean); override;
    // function DoChanging: Boolean; override;
    function GetDataClass: TRichViewRVDataClass; override;
  public
    constructor Create(AOwner: TComponent); override;
    destructor Destroy; override;
    function BeforeChange(FromOutside: Boolean): Boolean; override;
    property Container: TcxCustomTRichViewEdit read GetContainer;
    // IcxContainerInnerControl
    function GetControl: TWinControl;
    function GetControlContainer: TcxContainer;
    procedure DragDrop(Source: TObject; X, Y: Integer); override;
    property Control: TWinControl read GetControl;
    property ControlContainer: TcxContainer read GetControlContainer;
    // IcxInnerEditHelper
    function GetHelper: IcxCustomInnerEdit;
    procedure SetBounds(ALeft, ATop, AWidth, AHeight: Integer); override;
    procedure MouseDown(Button: TMouseButton; Shift: TShiftState;
      X, Y: Integer); override;
    procedure MouseMove(Shift: TShiftState; X, Y: Integer); override;
    procedure MouseUp(Button: TMouseButton; Shift: TShiftState; X, Y: Integer);
      override;
  end;

  TcxCustomTRichViewEdit = class(TcxCustomEdit)
  private
    FInnerEditPositionAdjusting: Boolean;
    FCanCreateScrollBars:        Boolean;
    FOldScrollBars:              TScrollStyle;
    FEditPopupMenu:              TComponent;
    procedure EditPopupMenuClick(Sender: TObject);
    function GetProperties: TcxCustomRVProperties;
    procedure SetProperties(const Value: TcxCustomRVProperties);
    function GetActiveProperties: TcxCustomRVProperties;
    function GetInnerEditor: TcxInnerTRichViewEdit;
    procedure DoCopy(Sender: TObject);
    procedure DoAddStyle(Sender: TCustomRichView; StyleInfo: TCustomRVInfo);
    procedure DoControlAction(Sender: TCustomRichView;
      ControlAction: TRVControlAction; ItemNo: Integer; var ctrl: TControl);
    procedure DoGetItemCursor(Sender: TCustomRichView; RVData: TCustomRVData;
      ItemNo: Integer; var Cursor: TCursor);
    procedure DoImportPicture(Sender: TCustomRichView; const Location: String;
      Width, Height: Integer; var Graphic: TGraphic);
    procedure DoItemAction(Sender: TCustomRichView; ItemAction: TRVItemAction;
      Item: TCustomRVItemInfo; var Text: TRVRawByteString;
      RVData: TCustomRVData);
    procedure DoItemHint(Sender: TCustomRichView; RVData: TCustomRVData;
      ItemNo: Integer; var HintText: String);
    procedure DoJump(Sender: TObject; id: Integer);
    procedure DoHTMLSaveImage(Sender: TCustomRichView; RVData: TCustomRVData;
      ItemNo: Integer; const Path: String; BackgroundColor: TColor;
      var Location: String; var DoDefault: Boolean);
    procedure DoPaint_(Sender: TCustomRichView; Canvas: TCanvas;
      Prepaint: Boolean);
    procedure DoProgress(Sender: TCustomRichView; Operation: TRVLongOperation;
      Stage: TRVProgressStage; PercentDone: Byte);
    procedure DoReadHyperlink(Sender: TCustomRichView;
      const Target, Extras: String; DocFormat: TRVLoadFormat;
      var StyleNo: Integer; var ItemTag: TRVTag;
      var ItemName: TRVRawByteString);
    procedure DoRVDblClick(Sender: TCustomRichView;
      ClickedWord: TRVRawByteString; Style: Integer);
    procedure DoRVFImageListNeeded(Sender: TCustomRichView;
      ImageListTag: Integer; var il: TCustomImageList);
    procedure DoRVFControlNeeded(Sender: TCustomRichView; Name: String;
      const Tag: TRVTag; var ctrl: TControl);
    procedure DoRVFPictureNeeded(Sender: TCustomRichView;
      const ItemName: String; Item: TRVNonTextItemInfo; Index1, Index2: Integer;
      var gr: TGraphic);
    procedure DoRVMouseDown(Sender: TCustomRichView; Button: TMouseButton;
      Shift: TShiftState; ItemNo, X, Y: Integer);
    procedure DoRVMouseUp(Sender: TCustomRichView; Button: TMouseButton;
      Shift: TShiftState; ItemNo, X, Y: Integer);
    procedure DoRVMouseMoveEvent(Sender: TObject; id: Integer);
    procedure DoSaveComponentToFile(Sender: TCustomRichView; Path: String;
      SaveMe: TPersistent; SaveFormat: TRVSaveFormat; var OutStr: String);
    procedure DoSaveHTMLExtra(Sender: TCustomRichView; Area: TRVHTMLSaveArea;
      CSSVersion: Boolean; var HTMLCode: String);
    procedure DoSaveImage2(Sender: TCustomRichView; Graphic: TGraphic;
      SaveFormat: TRVSaveFormat; const Path, ImagePrefix: String;
      var ImageSaveNo: Integer; var Location: String; var DoDefault: Boolean);
    procedure DoSaveItemToFile(Sender: TCustomRichView; const Path: String;
      RVData: TCustomRVData; ItemNo: Integer; SaveFormat: TRVSaveFormat;
      Unicode: Boolean; var OutStr: TRVRawByteString; var DoDefault: Boolean);
    procedure DoSaveRTFExtra(Sender: TCustomRichView; Area: TRVRTFSaveArea;
      Obj: TObject; Index1, Index2: Integer; InStyleSheet: Boolean;
      var RTFCode: TRVAnsiString);
    procedure DoSelect(Sender: TObject);
    {$IFNDEF RVDONOTUSELIVESPELL}
    procedure DoSpellingCheck(Sender: TCustomRichView; const AWord: String;
      StyleNo: Integer; var Misspelled: Boolean);
    {$ENDIF}
    procedure DoWriteHyperlink(Sender: TCustomRichView; id: Integer;
      RVData: TCustomRVData; ItemNo: Integer; SaveFormat: TRVSaveFormat;
      var Target, Extras: String);
    procedure DoCaretGetOut(Sender: TCustomRichViewEdit;
      Direction: TRVGetOutDirection);
    procedure DoCaretMove(Sender: TObject);
    procedure DoDropFiles(Sender: TCustomRichViewEdit; Files: TStrings;
      var FileAction: TRVDropFileAction; var DoDefault: Boolean);
    procedure DoParaStyleConversion(Sender: TCustomRichViewEdit;
      StyleNo, UserData: Integer; AppliedToText: Boolean;
      var NewStyleNo: Integer);
    procedure DoStyleConversion(Sender: TCustomRichViewEdit;
      StyleNo, UserData: Integer; AppliedToText: Boolean;
      var NewStyleNo: Integer);
    procedure DoCurParaStyleChanged(Sender: TObject);
    procedure DoCurTextStyleChanged(Sender: TObject);
    procedure DoItemTextEdit(Sender: TCustomRichViewEdit;
      const OldText: TRVRawByteString; RVData: TCustomRVData; ItemNo: Integer;
      var NewTag: TRVTag; var NewStyleNo: Integer);
    procedure DoDrawCustomCaret(Sender: TCustomRichViewEdit; Canvas: TCanvas;
      const Rect: TRect);
    procedure DoMeasureCustomCaret(Sender: TCustomRichViewEdit;
      var Rect: TRect);
    procedure DoItemResize(Sender: TCustomRichViewEdit;
      RVData: TCustomRVFormattedData; ItemNo, Val1, Val2: Integer);
    procedure DoLoadValue(Sender: TObject);
  protected
    function CanAutoSize: Boolean; override;
    function GetEditValue: TcxEditValue; override;
    procedure InternalSetEditValue(const Value: TcxEditValue;
      AValidateEditValue: Boolean); override;
    function WantNavigationKeys: Boolean; override;
    procedure SetParent(AParent: TWinControl); override;
    procedure Initialize; override;
    procedure SynchronizeDisplayValue; override;
    procedure InternalSetDisplayValue(const Value: TcxEditValue); override;
    procedure SetInternalDisplayValue(Value: TcxEditValue); override;
    procedure AdjustInnerEditPosition; override;
    function GetInnerEditClass: TControlClass; override;
    function NeedsScrollBars: Boolean; override;
    procedure InitScrollBarsParameters; override;
    procedure Scroll(AScrollBarKind: TScrollBarKind; AScrollCode: TScrollCode;
      var AScrollPos: Integer); override;
    procedure PropertiesChanged(Sender: TObject); override;
    procedure Notification(AComponent: TComponent;
      Operation: TOperation); override;
    // procedure AdjustInnerControl; override;
    procedure AdjustInnerEdit;
    function GetVScrollBarBounds: TRect; override;
    function GetHScrollBarBounds: TRect; override;
    procedure AdjustScrollBarPosition(AScrollBar: IcxControlScrollBar);
      override;
    function DoRefreshContainer(const P: TPoint; Button: TcxMouseButton;
      Shift: TShiftState; AIsMouseEvent: Boolean): Boolean; override;
    function UpdateContentOnFocusChanging: Boolean; override;
    procedure ChangeHandler(Sender: TObject); override;
    procedure InternalValidateDisplayValue(const ADisplayValue
      : TcxEditValue); override;
    procedure WndProc(var Message: TMessage); override;
    procedure Loaded; override;
    procedure InitializeInnerEdit; override;
    function GetEditPopupMenuInstance: TComponent; virtual;
    procedure UpdateEditPopupMenuItems(APopupMenu: TComponent); virtual;
    function DoShowPopupMenu(AMenu: TComponent; X, Y: Integer)
      : Boolean; override;
  public
    constructor Create(AOwner: TComponent); override;
    destructor Destroy; override;
    function SupportsSpelling: Boolean; override;
    class function GetPropertiesClass: TcxCustomEditPropertiesClass; override;
    property Properties: TcxCustomRVProperties read GetProperties
      write SetProperties;
    property ActiveProperties: TcxCustomRVProperties read GetActiveProperties;
    property InnerEditor: TcxInnerTRichViewEdit read GetInnerEditor;
    property EditPopupMenu: TComponent read FEditPopupMenu write FEditPopupMenu;
  end;

  {$IFDEF RICHVIEWDEFXE2}
  [ComponentPlatformsAttribute(pidWin32 or pidWin64)]
  {$ENDIF}

  TcxTRichViewEdit = class(TcxCustomTRichViewEdit)
  private
    function GetActiveProperties: TcxRVProperties;
    function GetProperties: TcxRVProperties;
    procedure SetProperties(Value: TcxRVProperties);
  public
    class function GetPropertiesClass: TcxCustomEditPropertiesClass; override;
    property ActiveProperties: TcxRVProperties read GetActiveProperties;
  published
    property Align;
    property Anchors;
    property AutoSize;
    property Constraints;
    property DragCursor;
    property DragKind;
    property DragMode;
    property Enabled;
    property ParentColor;
    property ParentShowHint;
    property PopupMenu;
    property Properties: TcxRVProperties read GetProperties write SetProperties;
    property ShowHint;
    property Style;
    property StyleDisabled;
    property StyleFocused;
    property StyleHot;
    property TabOrder;
    property TabStop;
    property Transparent;
    property Visible;
    property OnClick;
    property OnContextPopup;
    property OnDblClick;
    property OnDragDrop;
    property OnDragOver;
    property OnEditing;
    property OnEndDock;
    property OnEndDrag;
    property OnEnter;
    property OnExit;
    property OnKeyDown;
    property OnKeyPress;
    property OnKeyUp;
    property OnMouseDown;
    property OnMouseMove;
    property OnMouseUp;
    property OnStartDock;
    property OnStartDrag;
  end;

resourcestring
  scxSEditRepositoryRVItem =
    'TRichViewEdit |Represents an advanced rich text editor';

implementation

uses cxExtEditConsts;

{------------------------------------------------------------------------------}
function VarTypeIsUnicodeStr(const AVarType: TVarType): Boolean;
begin
  Result := (AVarType = varOleStr){$IFDEF DELPHI12} or
    (AVarType = varUString){$ENDIF};
end;

{------------------------------------------------------------------------------}
function VarIsUnicodeStr(const AValue: Variant): Boolean;
begin
  Result := VarTypeIsUnicodeStr(FindVarData(AValue)^.VType);
end;

{------------------------------------------------------------------------------}
procedure LoadValue(const Value: TcxEditValue; Edit: TCustomRichView;
  Unicode: Boolean; DefFont: TFont);
var
  StrW:   TRVUnicodeString;
  StrA:   TRVAnsiString;
  Stream: TRVMemoryStream;
  r:      Boolean;
  i:      Integer;
begin
  Edit.Clear;
  Edit.DeleteUnusedStyles(True, True, True);
  for i := 0 to Edit.Style.TextStyles.Count - 1 do
    Edit.Style.TextStyles[i].Unicode := Unicode;
  if DefFont <> nil then
    Edit.Style.TextStyles[0].Assign(DefFont);
  if VarIsUnicodeStr(Value) then
  begin
    StrW := Value;
    r := False;
    if Copy(StrW, 1, 6) = '{\rtf1' then
    begin
      StrA := TRVAnsiString(StrW);
      Stream := TRVMemoryStream.Create;
      try
        Stream.WriteBuffer(Pointer(StrA)^, Length(StrA));
        Stream.Position := 0;
        r := Edit.LoadRTFFromStream(Stream);
      finally
        Stream.Free;
      end;
      if not r then
        Edit.Clear;
    end;
    if not r then
      Edit.AddTextNLW(StrW, 0, 0, 0, False);
  end
  else if VarIsStr(Value) or VarIsArray(Value) then
  begin
    StrA := dxVariantToAnsiString(Value);
    Stream := TRVMemoryStream.Create;
    try
      Stream.WriteBuffer(Pointer(StrA)^, Length(StrA));
      Stream.Position := 0;
      Edit.LoadFromStream(Stream, rvynaNo);
    finally
      Stream.Free;
    end;
  end;
end;

{------------------------------------------------------------------------------}
procedure GetRVSize(Helper: TRVReportHelper; var Sz: TSize);
var
  Canvas: TCanvas;
  DC:     HDC;
  i:      Integer;
  RVData: TCustomRVFormattedData;
begin
  DC := CreateCompatibleDC(0);
  Canvas := TCanvas.Create;
  try
    Canvas.Handle := DC;
    if Sz.cx <= 0 then
      Helper.Init(Canvas, $7FFFFFFF)
    else
      Helper.Init(Canvas, Sz.cx);
    Helper.FormatNextPage($7FFFFFFF);
    Sz.cy := Helper.GetLastPageHeight;
    if Sz.cx <= 0 then
    begin
      RVData := Helper.RichView.RVData;
      for i := 0 to RVData.DrawItems.Count - 1 do
        if RVData.DrawItems[i].ObjectLeft + RVData.DrawItems[i].ObjectWidth >
          Sz.cx then
          Sz.cx := RVData.DrawItems[i].ObjectLeft + RVData.DrawItems[i]
            .ObjectWidth;
      inc(Sz.cx, Helper.RichView.RightMargin);
    end;
  finally
    Canvas.Handle := 0;
    Canvas.Free;
    DeleteDC(DC);
  end;
end;

{------------------------------------------------------------------------------}
function GetDefHeightRVS(RVStyle: TRVStyle; LineCount: Integer): Integer;
var
  Canvas:      TCanvas;
  DC:          HDC;
  LineSpacing: Integer;
begin
  if LineCount = 0 then
    LineCount := 1;
  DC := CreateCompatibleDC(0);
  Canvas := TCanvas.Create;
  try
    Canvas.Handle := DC;
    RVStyle.ApplyStyle(Canvas, 0, rvbdUnspecified, True, True, nil, True,
      False, False);
    Result := Canvas.TextHeight('Wg');
    LineSpacing := RVStyle.ParaStyles[0].LineSpacing;
    case RVStyle.ParaStyles[0].LineSpacingType of
      rvlsPercent:
        begin
          if LineSpacing < 50 then
            LineSpacing := 100;
          Result := MulDiv(Result, LineSpacing, 100);
        end;
      rvlsSpaceBetween:
        if LineSpacing >= 0 then
          inc(Result, LineSpacing);
      rvlsLineHeightAtLeast:
        if LineSpacing > Result then
          Result := LineSpacing;
      rvlsLineHeightExact:
        if LineSpacing > 0 then
          Result := LineSpacing;
    end;
  finally
    Canvas.Handle := 0;
    Canvas.Free;
    DeleteDC(DC);
  end;
  Result := Result * LineCount;
  inc(Result, RVStyle.ParaStyles[0].SpaceBefore);
  inc(Result, RVStyle.ParaStyles[0].SpaceAfter);
end;

{------------------------------------------------------------------------------}
procedure GetAutoSize(const Value: TcxEditValue; srcrv: TCustomRichView;
  LineCount: Integer; var Sz: TSize; Unicode: Boolean; DefFont: TFont);
var
  Helper: TRVReportHelper;
begin
  Helper := TRVReportHelper.Create(nil);
  Helper.RichView.Style := TRVStyle.Create(Helper);
  try
    Helper.IgnorePageBreaks := True;
    Helper.RichView.Options := srcrv.Options;
    Helper.RichView.RTFReadProperties := srcrv.RTFReadProperties;
    Helper.RichView.RVFOptions := srcrv.RVFOptions;
    Helper.RichView.RVFParaStylesReadMode := srcrv.RVFParaStylesReadMode;
    Helper.RichView.RVFTextStylesReadMode := srcrv.RVFTextStylesReadMode;
    Helper.RichView.LeftMargin := srcrv.LeftMargin;
    Helper.RichView.TopMargin := srcrv.TopMargin;
    Helper.RichView.RightMargin := srcrv.RightMargin;
    Helper.RichView.BottomMargin := srcrv.BottomMargin;
    LoadValue(Value, Helper.RichView, Unicode, DefFont);
    if LineCount > 0 then
      Sz.cy := GetDefHeightRVS(Helper.RichView.Style, LineCount) +
        srcrv.TopMargin + srcrv.BottomMargin
    else
      GetRVSize(Helper, Sz);
  finally
    Helper.Free;
  end;
end;

{=============================== TcxRVViewInfo ================================}
destructor TcxRVViewInfo.Destroy;
begin
  FreeAndNil(FReportHelper);
  inherited;
end;

{------------------------------------------------------------------------------}
procedure TcxRVViewInfo.InitReportHelper;
begin
  if FReportHelper = nil then
  begin
    FReportHelper := TRVReportHelper.Create(nil);
    FReportHelper.IgnorePageBreaks := True;
    FReportHelper.RichView.Style := TRVStyle.Create(FReportHelper);
    FReportHelper.RichView.LeftMargin := 5;
    FReportHelper.RichView.TopMargin := 5;
    FReportHelper.RichView.RightMargin := 5;
    FReportHelper.RichView.BottomMargin := 5;
    with FReportHelper.RichView do
    begin
      RVFOptions := [rvfoSavePicturesBody, rvfoSaveControlsBody, rvfoSaveBinary,
        rvfoSaveDocProperties, rvfoLoadDocProperties, rvfoSaveTextStyles,
        rvfoSaveParaStyles, rvfoSaveBack, rvfoLoadBack, rvfoSaveLayout,
        rvfoLoadLayout];
      Options := [rvoAllowSelection, rvoScrollToEnd, rvoTagsArePChars,
      {$IFDEF RVUNICODEWINDOW}rvoAutoCopyUnicodeText, {$ELSE}rvoAutoCopyText,
      {$ENDIF}
      rvoAutoCopyImage, rvoAutoCopyRVF, rvoAutoCopyRTF, rvoDblClickSelectsWord,
        rvoRClickDeselects, rvoFormatInvalidate, rvoShowPageBreaks,
        rvoFastFormatting];
      RVFParaStylesReadMode := rvf_sInsertMerge;
      RVFTextStylesReadMode := rvf_sInsertMerge;
      RTFReadProperties.TextStyleMode := rvrsAddIfNeeded;
      RTFReadProperties.ParaStyleMode := rvrsAddIfNeeded;
    end;
  end;
end;

{------------------------------------------------------------------------------}
procedure TcxRVViewInfo.InternalPaint(ACanvas: TcxCanvas);
var
  r:  TRect;
  pt: TPoint;
begin
  inherited;
  if (FReportHelper = nil) or not IsInplace then
    exit;
  if not FUseDocColor then
    FReportHelper.RichView.Color := BackgroundColor;
  if not FUseDocFontColor then
    FReportHelper.RichView.Style.TextStyles[0].Color := TextColor;

  r := ClientRect;
  ACanvas.Canvas.Lock;
  try
    FReportHelper.Init(ACanvas.Canvas, r.Right - r.Left);
  finally
    ACanvas.Canvas.UnLock;
  end;

  FReportHelper.FormatNextPage(MaxInt);
  FReportHelper.RichView.Style.GraphicInterface.GetWindowOrgEx
    (ACanvas.Canvas, pt);
  FReportHelper.DrawPageAt(-pt.X + r.Left, -pt.Y + r.Top, 1, ACanvas.Canvas,
    True, r.Bottom - r.Top);

  {
   ACanvas.Canvas.Brush.Style := bsSolid;
   ACanvas.Canvas.Brush.Color := clWhite;
   ACanvas.Canvas.FillRect(ClientRect);
   ACanvas.Canvas.Pen.Style := psSolid;
   ACanvas.Canvas.Pen.Color := clRed;
   with ClientRect do
   ACanvas.Canvas.Ellipse(Left, Top, Right, Bottom);
  }
end;
{================================= TcxRVViewData ==============================}

procedure TcxRVViewData.Calculate(ACanvas: TcxCanvas; const ABounds: TRect;
  const P: TPoint; Button: TcxMouseButton; Shift: TShiftState;
  AViewInfo: TcxCustomEditViewInfo; AIsMouseEvent: Boolean);
begin
  inherited;

end;

{------------------------------------------------------------------------------}
procedure TcxRVViewData.EditValueToDrawValue(const AEditValue: TcxEditValue;
  AViewInfo: TcxCustomEditViewInfo);
var
  LProperties: TcxCustomRVProperties;
begin
  with (AViewInfo as TcxRVViewInfo) do
  begin
    InitReportHelper;
    FUseDocColor := (Properties as TcxCustomRVProperties).IsColorStoredInDoc;
    FUseDocFontColor := (Properties as TcxCustomRVProperties).IsFontStoredInDoc;
    LProperties := (Properties as TcxCustomRVProperties);
    LProperties.AssignToTRichView(FReportHelper.RichView);
    LoadValue(AEditValue, FReportHelper.RichView, LProperties.Unicode,
      LProperties.DefFont);
  end;
end;

{------------------------------------------------------------------------------}
function TcxRVViewData.GetEditContentSize(ACanvas: TcxCanvas;
  const AEditValue: TcxEditValue;
  const AEditSizeProperties: TcxEditSizeProperties;
  AErrorData: TcxEditValidateInfo): TSize;
var
  ViewInfo:    TcxRVViewInfo;
  LProperties: TcxCustomRVProperties;
begin
  inherited GetEditContentSize(ACanvas, AEditValue, AEditSizeProperties);
  Result.cx := AEditSizeProperties.Width;
  Result.cy := -1;
  if IsInplace then
  begin
    if Edit <> nil then
    begin
      LProperties := (Properties as TcxCustomRVProperties);
      GetAutoSize(AEditValue, TcxCustomTRichViewEdit(Edit).InnerEditor,
        LProperties.VisibleLineCount, Result, LProperties.Unicode,
        LProperties.DefFont)
    end
    else
    begin
      ViewInfo := TcxRVViewInfo.Create;
      try
        ViewInfo.InitReportHelper;
        LProperties := (Properties as TcxCustomRVProperties);
        LProperties.AssignToTRichView(ViewInfo.FReportHelper.RichView);
        GetAutoSize(AEditValue, ViewInfo.FReportHelper.RichView,
          LProperties.VisibleLineCount, Result, LProperties.Unicode,
          LProperties.DefFont)
      finally
        ViewInfo.Free;
      end;
    end;
  end
  else if Edit <> nil then
  begin
    LProperties := (Properties as TcxCustomRVProperties);
    GetAutoSize(AEditValue, TcxCustomTRichViewEdit(Edit).InnerEditor,
      LProperties.VisibleLineCount, Result, LProperties.Unicode,
      LProperties.DefFont);
  end
  else
    Result.cy := 0;
end;

{------------------------------------------------------------------------------}
function TcxRVViewData.GetClientExtent(ACanvas: TcxCanvas;
  AViewInfo: TcxCustomEditViewInfo): TRect;
begin
  Result := // inherited GetClientExtent(ACanvas, AViewInfo);
    GetBorderExtent;
end;

{========================== TcxRVRTFReaderProperties ==========================}
constructor TcxRVRTFReaderProperties.Create(AOwner: TcxCustomRVProperties);
begin
  inherited Create;
  TextStyleMode := rvrsAddIfNeeded;
  ParaStyleMode := rvrsAddIfNeeded;
  UnicodeMode := rvruOnlyUnicode;
  FOwner := AOwner;
end;

{------------------------------------------------------------------------------}
procedure TcxRVRTFReaderProperties.Changed;
begin
  if FOwner <> nil then
    FOwner.Changed;
end;

{================================ TcxRVDefFont ================================}
procedure TcxRVDefFont.Changed;
begin
  if FOwner <> nil then
    FOwner.Changed;
  inherited Changed;
end;

{------------------------------------------------------------------------------}
constructor TcxRVDefFont.Create(AOwner: TcxCustomRVProperties);
begin
  inherited Create;
  Name := 'Arial';
  Size := 8;
  FOwner := AOwner;
end;

{=============================== TcxCustomRVProperties ========================}
constructor TcxCustomRVProperties.Create(AOwner: TPersistent);
begin
  inherited;
  FScrollBars := ssNone;
  FEditValueSaveFormat := cxrvvfRVF;
  {$IFNDEF RVDONOTUSEANIMATION}
  FAnimationMode := rvaniManualStart;
  {$ENDIF}
  {$IFNDEF RVDONOTUSESTYLETEMPLATES}
  FUseStyleTemplates := False;
  FStyleTemplateInsertMode := rvstimUseTargetFormatting;
  {$ENDIF}
  FBottomMargin := 5;
  FLeftMargin := 5;
  FRightMargin := 5;
  FTopMargin := 5;
  FDelimiters := RVDEFAULTDELIMITERS;
  FRTFOptions := [rvrtfDuplicateUnicode, rvrtfSaveEMFAsWMF,
    rvrtfSaveJpegAsJpeg];
  FRVFOptions := [rvfoSavePicturesBody, rvfoSaveControlsBody, rvfoSaveBinary,
    rvfoSaveDocProperties, rvfoLoadDocProperties, rvfoSaveTextStyles,
    rvfoSaveParaStyles, rvfoSaveBack, rvfoLoadBack, rvfoSaveLayout,
    rvfoLoadLayout];
  FOptions := [rvoAllowSelection, rvoScrollToEnd, rvoTagsArePChars,
  {$IFDEF RVUNICODEWINDOW}rvoAutoCopyUnicodeText, {$ELSE}rvoAutoCopyText,
  {$ENDIF}
  rvoAutoCopyImage, rvoAutoCopyRVF, rvoAutoCopyRTF, rvoDblClickSelectsWord,
    rvoRClickDeselects, rvoFormatInvalidate, rvoShowPageBreaks,
    rvoFastFormatting];
  FRVFParaStylesReadMode := rvf_sInsertMerge;
  FRVFTextStylesReadMode := rvf_sInsertMerge;
  FVAlign := tlTop;
  FWordWrap := True;
  FAcceptDragDropFormats := [rvddRVF, rvddRTF, rvddText, rvddUnicodeText,
    rvddBitmap, rvddMetafile, rvddFiles];
  FEditorOptions := [rvoWantTabs, rvoCtrlJumps];
  FUndoLimit := -1;
  FUnicode := True;
  FDefFont := TcxRVDefFont.Create(Self);
end;

{------------------------------------------------------------------------------}
destructor TcxCustomRVProperties.Destroy;
begin
  FreeAndNil(FRTFReadProperties);
  FreeAndNil(FBackBitmap);
  FreeAndNil(FDefFont);
  inherited;
end;

{------------------------------------------------------------------------------}
procedure TcxCustomRVProperties.Assign(Source: TPersistent);
begin
  if Source is TcxCustomRVProperties then
  begin
    BeginUpdate;
    try
      inherited Assign(Source);
      with Source as TcxCustomRVProperties do
      begin
        Self.EditValueSaveFormat := FEditValueSaveFormat;
        Self.ScrollBars := ScrollBars;
        Self.Unicode := Unicode;
        Self.DefFont := DefFont;
        Self.VisibleLineCount := VisibleLineCount;
        Self.OnLoadValue := OnLoadValue;
        {$IFNDEF RVDONOTUSESTYLETEMPLATES}
        Self.UseStyleTemplates := UseStyleTemplates;
        Self.StyleTemplateInsertMode := StyleTemplateInsertMode;
        {$ENDIF}
        {$IFNDEF RVDONOTUSEANIMATION}
        Self.AnimationMode := AnimationMode;
        {$ENDIF}
        Self.BackgroundBitmap := BackgroundBitmap;
        Self.BackgroundStyle := BackgroundStyle;
        Self.BiDiMode := BiDiMode;
        Self.BottomMargin := BottomMargin;
        Self.Delimiters := Delimiters;
        {$IFNDEF RVDONOTUSEDOCPARAMS}
        // Self.DocParameters := DocParameters;
        {$ENDIF}
        Self.LeftMargin := LeftMargin;
        Self.MaxLength := MaxLength;
        Self.MaxTextWidth := MaxTextWidth;
        Self.MinTextWidth := MinTextWidth;
        Self.Options := Options;
        Self.RightMargin := RightMargin;
        Self.RTFOptions := RTFOptions;
        Self.RTFReadProperties := RTFReadProperties;
        Self.RVFOptions := RVFOptions;
        Self.RVFParaStylesReadMode := RVFParaStylesReadMode;
        Self.RVFTextStylesReadMode := RVFParaStylesReadMode;
        Self.TopMargin := TopMargin;
        Self.VAlign := VAlign;
        Self.WordWrap := WordWrap;

        Self.AcceptDragDropFormats := AcceptDragDropFormats;
        Self.CustomCaretInterval := CustomCaretInterval;
        Self.EditorOptions := EditorOptions;
        Self.UndoLimit := UndoLimit;

        Self.OnAddStyle := OnAddStyle;
        Self.OnControlAction := OnControlAction;
        Self.OnCopy := OnCopy;
        Self.OnGetItemCursor := OnGetItemCursor;
        Self.OnImportPicture := OnImportPicture;
        Self.OnItemAction := OnItemAction;
        Self.OnItemHint := OnItemHint;
        Self.OnJump := OnJump;
        Self.OnHTMLSaveImage := OnHTMLSaveImage;
        Self.OnPaint := OnPaint;
        Self.OnProgress := OnProgress;
        Self.OnReadHyperlink := OnReadHyperlink;
        Self.OnRVDblClick := OnRVDblClick;
        Self.OnRVFImageListNeeded := OnRVFImageListNeeded;
        Self.OnRVFControlNeeded := OnRVFControlNeeded;
        Self.OnRVFPictureNeeded := OnRVFPictureNeeded;
        Self.OnRVMouseDown := OnRVMouseDown;
        Self.OnRVMouseMove := OnRVMouseMove;
        Self.OnRVMouseUp := OnRVMouseUp;
        Self.OnSaveComponentToFile := OnSaveComponentToFile;
        Self.OnSaveHTMLExtra := OnSaveHTMLExtra;
        Self.OnSaveImage2 := OnSaveImage2;
        Self.OnSaveItemToFile := OnSaveItemToFile;
        Self.OnSaveRTFExtra := OnSaveRTFExtra;
        Self.OnSelect := OnSelect;
        {$IFNDEF RVDONOTUSELIVESPELL}
        Self.OnSpellingCheck := OnSpellingCheck;
        {$ENDIF}
        Self.OnWriteHyperlink := OnWriteHyperlink;

        Self.OnCaretGetOut := OnCaretGetOut;
        Self.OnCaretMove := OnCaretMove;
        Self.OnDropFiles := OnDropFiles;
        Self.OnParaStyleConversion := OnParaStyleConversion;
        Self.OnStyleConversion := OnStyleConversion;
        Self.OnCurParaStyleChanged := OnCurParaStyleChanged;
        Self.OnCurTextStyleChanged := OnCurTextStyleChanged;
        Self.OnItemTextEdit := OnItemTextEdit;
        {$IFNDEF RVDONOTUSEDRAGDROP}
        {
         Self.OnOleDragEnter := OnOleDragEnter;
         Self.OnOleDragOver := OnOleDragOver;
         Self.OnOleDrop := OnOleDrop;
         Self.OnOleDragLeave := OnOleDragLeave;
        }
        {$ENDIF}
        Self.OnDrawCustomCaret := OnDrawCustomCaret;
        Self.OnMeasureCustomCaret := OnMeasureCustomCaret;
        Self.OnItemResize := OnItemResize;
      end;
    finally
      EndUpdate;
    end
  end
  else
    inherited Assign(Source);
end;

{------------------------------------------------------------------------------}
function TcxCustomRVProperties.GetSupportedOperations
  : TcxEditSupportedOperations;
begin
  Result := inherited GetSupportedOperations + [esoEditingAutoHeight,
    esoAutoHeight];
end;

{------------------------------------------------------------------------------}
function TcxCustomRVProperties.GetEditValueSource(AEditFocused: Boolean)
  : TcxDataEditValueSource;
begin
  if (EditValueSaveFormat in [cxrvvfRVF]) or
    ((IDefaultValuesProvider <> nil) and IDefaultValuesProvider.IsBlob) then
    Result := evsValue
  else
    Result := evsText;
end;
{------------------------------------------------------------------------------}
{$IFNDEF RVDONOTUSESTYLETEMPLATES}

procedure TcxCustomRVProperties.SetUseStyleTemplates(Value: Boolean);
begin
  if Value <> FUseStyleTemplates then
  begin
    FUseStyleTemplates := Value;
    Changed;
  end;
end;

{------------------------------------------------------------------------------}
procedure TcxCustomRVProperties.SetStyleTemplateInsertMode
  (Value: TRVStyleTemplateInsertMode);
begin
  if Value <> FStyleTemplateInsertMode then
  begin
    FStyleTemplateInsertMode := Value;
    Changed;
  end;
end;
{$ENDIF}
{------------------------------------------------------------------------------}
{$IFNDEF RVDONOTUSEANIMATION}

procedure TcxCustomRVProperties.SetAnimationMode(const Value: TRVAnimationMode);
begin
  if Value <> FAnimationMode then
  begin
    FAnimationMode := Value;
    Changed;
  end;
end;
{$ENDIF}

{------------------------------------------------------------------------------}
procedure TcxCustomRVProperties.SetAcceptDragDropFormats
  (const Value: TRVDragDropFormats);
begin
  if Value <> FAcceptDragDropFormats then
  begin
    FAcceptDragDropFormats := Value;
    Changed;
  end;
end;

{------------------------------------------------------------------------------}
procedure TcxCustomRVProperties.SetBackBitmap(const Value: TBitmap);
begin
  if Value <> FBackBitmap then
  begin
    if Value = nil then
      FreeAndNil(FBackBitmap)
    else
      BackgroundBitmap.Assign(Value);
    Changed;
  end;
end;

{------------------------------------------------------------------------------}
procedure TcxCustomRVProperties.SetBackgroundStyle
  (const Value: TBackgroundStyle);
begin
  if Value <> FBackgroundStyle then
  begin
    FBackgroundStyle := Value;
    Changed;
  end;
end;

{------------------------------------------------------------------------------}
procedure TcxCustomRVProperties.SetBiDiModeRV(const Value: TRVBiDiMode);
begin
  if Value <> FBiDiMode then
  begin
    FBiDiMode := Value;
    Changed;
  end;
end;

{------------------------------------------------------------------------------}
procedure TcxCustomRVProperties.SetBottomMargin(const Value: Integer);
begin
  if Value <> FBottomMargin then
  begin
    FBottomMargin := Value;
    Changed;
  end;
end;

{------------------------------------------------------------------------------}
procedure TcxCustomRVProperties.SetCustomCaretInterval(const Value: Integer);
begin
  if Value <> FCustomCaretInterval then
  begin
    FCustomCaretInterval := Value;
    Changed;
  end;
end;

{------------------------------------------------------------------------------}
procedure TcxCustomRVProperties.SetDefFont(const Value: TcxRVDefFont);
begin
  FDefFont.Assign(Value);
end;

{------------------------------------------------------------------------------}
procedure TcxCustomRVProperties.SetDelimiters(const Value: String);
begin
  if Value <> FDelimiters then
  begin
    FDelimiters := Value;
    Changed;
  end;
end;

{------------------------------------------------------------------------------}
procedure TcxCustomRVProperties.SetEditorOptions(const Value: TRVEditorOptions);
begin
  if Value <> FEditorOptions then
  begin
    FEditorOptions := Value;
    Changed;
  end;
end;
{------------------------------------------------------------------------------}
{$IFNDEF RVDONOTUSEDOCPARAMS}
{
 procedure TcxCustomRVProperties.SetDocParameters(const Value: TRVDocParameters);
 begin
 if Value <> FDocParameters then begin
 if Value=nil then
 FreeAndNil(FDocParameters)
 else
 DocParameters.Assign(Value);
 Changed;
 end;
 end;
}
{$ENDIF}

{------------------------------------------------------------------------------}
procedure TcxCustomRVProperties.SetLeftMargin(const Value: Integer);
begin
  if Value <> FLeftMargin then
  begin
    FLeftMargin := Value;
    Changed;
  end;
end;

{------------------------------------------------------------------------------}
procedure TcxCustomRVProperties.SetMaxLength(const Value: Integer);
begin
  if Value <> FMaxLength then
  begin
    FMaxLength := Value;
    Changed;
  end;
end;

{------------------------------------------------------------------------------}
procedure TcxCustomRVProperties.SetMaxTextWidth(const Value: Integer);
begin
  if Value <> FMaxTextWidth then
  begin
    FMaxTextWidth := Value;
    Changed;
  end;
end;

{------------------------------------------------------------------------------}
procedure TcxCustomRVProperties.SetMinTextWidth(const Value: Integer);
begin
  if Value <> FMinTextWidth then
  begin
    FMinTextWidth := Value;
    Changed;
  end;
end;

{------------------------------------------------------------------------------}
procedure TcxCustomRVProperties.SetRightMargin(const Value: Integer);
begin
  if Value <> FRightMargin then
  begin
    FRightMargin := Value;
    Changed;
  end;
end;

{------------------------------------------------------------------------------}
procedure TcxCustomRVProperties.SetRTFOptions(const Value: TRVRTFOptions);
begin
  if Value <> FRTFOptions then
  begin
    FRTFOptions := Value;
    Changed;
  end;
end;

{------------------------------------------------------------------------------}
procedure TcxCustomRVProperties.SetRTFReadProperties
  (const Value: TcxRVRTFReaderProperties);
begin
  if Value <> FRTFReadProperties then
  begin
    if Value = nil then
      FreeAndNil(FRTFReadProperties)
    else
      RTFReadProperties.Assign(Value);
    Changed;
  end;
end;

{------------------------------------------------------------------------------}
procedure TcxCustomRVProperties.SetRVFOptions(const Value: TRVFOptions);
begin
  if Value <> FRVFOptions then
  begin
    FRVFOptions := Value;
    Changed;
  end;
end;

{------------------------------------------------------------------------------}
procedure TcxCustomRVProperties.SetRVFParaStylesReadMode
  (const Value: TRVFReaderStyleMode);
begin
  if Value <> FRVFParaStylesReadMode then
  begin
    FRVFParaStylesReadMode := Value;
    Changed;
  end;
end;

{------------------------------------------------------------------------------}
procedure TcxCustomRVProperties.SetRVFTextStylesReadMode
  (const Value: TRVFReaderStyleMode);
begin
  if Value <> FRVFTextStylesReadMode then
  begin
    FRVFTextStylesReadMode := Value;
    Changed;
  end;
end;

{------------------------------------------------------------------------------}
procedure TcxCustomRVProperties.SetScrollBars(Value: TScrollStyle);
begin
  if Value <> FScrollBars then
  begin
    FScrollBars := Value;
    Changed;
  end;
end;

{------------------------------------------------------------------------------}
procedure TcxCustomRVProperties.SetTopMargin(const Value: Integer);
begin
  if Value <> FTopMargin then
  begin
    FTopMargin := Value;
    Changed;
  end;
end;

{------------------------------------------------------------------------------}
procedure TcxCustomRVProperties.SetUndoLimit(const Value: Integer);
begin
  if Value <> FUndoLimit then
  begin
    FUndoLimit := Value;
    Changed;
  end;
end;

procedure TcxCustomRVProperties.SetUnicode(const Value: Boolean);
begin
  if Value <> FUnicode then
  begin
    FUnicode := Value;
    Changed;
  end;
end;

{------------------------------------------------------------------------------}
procedure TcxCustomRVProperties.SetVAlign(const Value: TTextLayout);
begin
  if Value <> FVAlign then
  begin
    FVAlign := Value;
    Changed;
  end;
end;

{------------------------------------------------------------------------------}
procedure TcxCustomRVProperties.SetVisibleLineCount(Value: Integer);
begin
  if Value < 0 then
    Value := 0;
  if Value <> FVisibleLineCount then
  begin
    FVisibleLineCount := Value;
    Changed;
  end;
end;

{------------------------------------------------------------------------------}
procedure TcxCustomRVProperties.SetWordWrap(const Value: Boolean);
begin
  if Value <> FWordWrap then
  begin
    FWordWrap := Value;
    Changed;
  end;
end;

{------------------------------------------------------------------------------}
function TcxCustomRVProperties.StoreDelimiters: Boolean;
begin
  Result := FDelimiters <> RVDEFAULTDELIMITERS;
end;
{------------------------------------------------------------------------------}
{$IFNDEF RVDONOTUSEDOCPARAMS}
{
 function TcxCustomRVProperties.StoreDocParameters: Boolean;
 begin
 Result := (FDocParameters<>nil) and not FDocParameters.AreAllValuesDefault;
 end;
}
{$ENDIF}

{------------------------------------------------------------------------------}
function TcxCustomRVProperties.GetBackBitmap: TBitmap;
begin
  if FBackBitmap = nil then
    FBackBitmap := TBitmap.Create;
  Result := FBackBitmap;
end;

{------------------------------------------------------------------------------}
class function TcxCustomRVProperties.GetContainerClass: TcxContainerClass;
begin
  Result := TcxTRichViewEdit;
end;
{------------------------------------------------------------------------------}
{$IFNDEF RVDONOTUSEDOCPARAMS}
{
 function TcxCustomRVProperties.GetDocParameters: TRVDocParameters;
 begin
 if FDocParameters=nil then
 FDocParameters := TRVDocParameters.Create;
 Result := FDocParameters;
 end;
}
{$ENDIF}

{------------------------------------------------------------------------------}
function TcxCustomRVProperties.GetRTFReadProperties: TcxRVRTFReaderProperties;
begin
  if FRTFReadProperties = nil then
    FRTFReadProperties := TcxRVRTFReaderProperties.Create(Self);
  Result := FRTFReadProperties;
end;

{------------------------------------------------------------------------------}
class function TcxCustomRVProperties.GetViewDataClass
  : TcxCustomEditViewDataClass;
begin
  Result := TcxRVViewData;
end;

{------------------------------------------------------------------------------}
class function TcxCustomRVProperties.GetViewInfoClass
  : TcxContainerViewInfoClass;
begin
  Result := TcxRVViewInfo;
end;

{------------------------------------------------------------------------------}
function TcxCustomRVProperties.HasDisplayValue: Boolean;
begin
  Result := True;
end;

{------------------------------------------------------------------------------}
function TcxCustomRVProperties.InnerEditNeedsTabs: Boolean;
begin
  Result := rvoWantTabs in EditorOptions;
end;

{------------------------------------------------------------------------------}
function TcxCustomRVProperties.IsColorStoredInDoc: Boolean;
begin
  Result := (FEditValueSaveFormat = cxrvvfRVF) and (rvfoSaveBack in FRVFOptions)
    and (rvfoLoadBack in FRVFOptions);
end;

{------------------------------------------------------------------------------}
function TcxCustomRVProperties.IsFontStoredInDoc: Boolean;
begin
  Result := FEditValueSaveFormat in [cxrvvfRVF, cxrvvfRTF];
end;

{------------------------------------------------------------------------------}
procedure TcxCustomRVProperties.AssignToTRichView(rv: TCustomRichView);
var
  i: Integer;
begin
  {$IFNDEF RVDONOTUSESTYLETEMPLATES}
  rv.UseStyleTemplates := UseStyleTemplates;
  rv.StyleTemplateInsertMode := StyleTemplateInsertMode;
  {$ENDIF}
  {$IFNDEF RVDONOTUSEANIMATION}
  rv.AnimationMode := AnimationMode;
  {$ENDIF}
  rv.BackgroundBitmap := BackgroundBitmap;
  rv.BackgroundStyle := BackgroundStyle;
  rv.BiDiMode := BiDiMode;
  rv.BottomMargin := BottomMargin;
  rv.Delimiters := Delimiters;
  {$IFNDEF RVDONOTUSEDOCPARAMS}
  // rv.DocParameters := DocParameters;
  {$ENDIF}
  rv.LeftMargin := LeftMargin;
  rv.MaxLength := MaxLength;
  rv.MaxTextWidth := MaxTextWidth;
  rv.MinTextWidth := MinTextWidth;
  rv.Options := Options;
  rv.RightMargin := RightMargin;
  rv.RTFOptions := RTFOptions;
  rv.RTFReadProperties := RTFReadProperties;
  rv.RVFOptions := RVFOptions;
  rv.RVFParaStylesReadMode := RVFParaStylesReadMode;
  rv.RVFTextStylesReadMode := RVFParaStylesReadMode;
  rv.TopMargin := TopMargin;
  rv.VAlign := VAlign;
  rv.WordWrap := WordWrap;

  if (rv.ItemCount = 0) or ((rv.ItemCount = 1) and (rv.GetItemStyle(0) = 0) and
    (rv.GetItemText(0) = '')) then
  begin
    for i := 0 to rv.Style.TextStyles.Count - 1 do
      rv.Style.TextStyles[i].Unicode := Unicode;
    rv.Style.TextStyles[0].Assign(DefFont);
    rv.Clear;
  end;
end;

{============================== TcxRVEditHelper ===============================}
function TcxRVEditHelper.CanProcessClipboardMessages: Boolean;
begin
  Result := True;
end;

{------------------------------------------------------------------------------}
constructor TcxRVEditHelper.Create(AEdit: TcxInnerTRichViewEdit);
begin
  inherited Create(nil);
  FEdit := AEdit;
  FAlignmentLock := False;
end;

{------------------------------------------------------------------------------}
function TcxRVEditHelper.CallDefWndProc(AMsg: UINT; WParam: WParam;
  LParam: LParam): LRESULT;
begin
  Result := CallWindowProc(Edit.DefWndProc, Edit.Handle, AMsg, WParam, LParam);
end;

{------------------------------------------------------------------------------}
function TcxRVEditHelper.GetControl: TWinControl;
begin
  Result := Edit;
end;

{------------------------------------------------------------------------------}
function TcxRVEditHelper.GetControlContainer: TcxContainer;
begin
  Result := Edit.Container;
end;

{------------------------------------------------------------------------------}
function TcxRVEditHelper.GetEditValue: TcxEditValue;
var
  Stream: TRVMemoryStream;
  StrW:   TRVUnicodeString;
  StrA:   TRVAnsiString;
begin
  Stream := TRVMemoryStream.Create;
  try
    case (GetControlContainer as TcxCustomTRichViewEdit)
      .ActiveProperties.EditValueSaveFormat of
      cxrvvfAnsiText:
        Edit.SaveTextToStream('', Stream, 80, False, False);
      cxrvvfUnicodeText:
        Edit.SaveTextToStreamW('', Stream, 80, False, False);
      cxrvvfRTF:
        Edit.SaveRTFToStream(Stream, False);
      else
        Edit.SaveRVFToStream(Stream, False);
    end;
    Stream.Position := 0;
    if (GetControlContainer as TcxCustomTRichViewEdit)
      .ActiveProperties.EditValueSaveFormat in [cxrvvfUnicodeText] then
    begin
      SetLength(StrW, Stream.Size div 2);
      Stream.ReadBuffer(Pointer(StrW)^, Length(StrW) * 2);
      Result := StrW;
    end
    else
    begin
      SetLength(StrA, Stream.Size);
      Stream.ReadBuffer(Pointer(StrA)^, Length(StrA));
      Result := StrA;
    end;
  finally
    Stream.Free;
  end;
end;

{------------------------------------------------------------------------------}
procedure TcxRVEditHelper.SetEditValue(const Value: TcxEditValue);
begin
  if Edit.Container <> nil then
  begin
    LoadValue(Value, Edit, Edit.Container.Properties.Unicode,
      Edit.Container.Properties.DefFont);
    Edit.Container.DoLoadValue(Edit);
  end
  else
    LoadValue(Value, Edit, True, nil);
  if ((Edit.Parent <> nil) or (Edit.ParentWindow <> 0)) and
    ((Edit.Container.Parent <> nil) or (Edit.Container.ParentWindow <> 0)) then
    Edit.Format;
end;

{------------------------------------------------------------------------------}
function TcxRVEditHelper.GetOnChange: TNotifyEvent;
begin
  Result := Edit.OnChange;
end;

{------------------------------------------------------------------------------}
procedure TcxRVEditHelper.SetOnChange(Value: TNotifyEvent);
begin
  Edit.OnChange := Value;
end;

{------------------------------------------------------------------------------}
function TcxRVEditHelper.GetReadOnly: Boolean;
begin
  Result := Edit.ReadOnly;
end;

{------------------------------------------------------------------------------}
procedure TcxRVEditHelper.SetReadOnly(Value: Boolean);
begin
  Edit.ReadOnly := Value;
end;

{------------------------------------------------------------------------------}
procedure TcxRVEditHelper.LockBounds(ALock: Boolean);
begin
  with Edit do
    if ALock then
      inc(FLockBoundsCount)
    else if FLockBoundsCount > 0 then
      Dec(FLockBoundsCount);
end;

{------------------------------------------------------------------------------}
procedure TcxRVEditHelper.SafelySetFocus;
begin
  Edit.SetFocus;
end;

{------------------------------------------------------------------------------}
procedure TcxRVEditHelper.SetParent(Value: TWinControl);
begin
  Edit.Parent := Value;
end;

{=============================== TcxInnerTRichViewEdit ========================}
constructor TcxInnerTRichViewEdit.Create(AOwner: TComponent);
begin
  FIsCreating := True;
  inherited;
  Style := TRVStyle.Create(Self);
  FHelper := TcxRVEditHelper.Create(Self);
  FIsCreating := False;
  VScrollVisible := False;
  HScrollVisible := False;
  BorderStyle := bsNone;
end;

{------------------------------------------------------------------------------}
destructor TcxInnerTRichViewEdit.Destroy;
begin
  FreeAndNil(FHelper);
  inherited;
end;

{------------------------------------------------------------------------------}
procedure TcxInnerTRichViewEdit.AfterHScroll;
begin
  inherited;
  if not FUpdatingScrollbars then
    Container.UpdateScrollbars;
end;

{------------------------------------------------------------------------------}
procedure TcxInnerTRichViewEdit.AfterVScroll;
begin
  inherited;
  if not FUpdatingScrollbars then
    Container.UpdateScrollbars;
end;

{------------------------------------------------------------------------------}
procedure TcxInnerTRichViewEdit.DoAfterResize;
begin
  inherited;
  if not FUpdatingScrollbars then
    Container.UpdateScrollbars;
end;

{------------------------------------------------------------------------------}
procedure TcxInnerTRichViewEdit.DragDrop(Source: TObject; X, Y: Integer);
begin
  Container.DragDrop(Source, Left + X, Top + Y);
end;

{------------------------------------------------------------------------------}
procedure TcxInnerTRichViewEdit.DragOver(Source: TObject; X, Y: Integer;
  State: TDragState; var Accept: Boolean);
begin
  Container.DragOver(Source, Left + X, Top + Y, State, Accept);
end;

{------------------------------------------------------------------------------}
function TcxInnerTRichViewEdit.GetContainer: TcxCustomTRichViewEdit;
begin
  Result := TcxCustomTRichViewEdit(Owner);
end;

{------------------------------------------------------------------------------}
function TcxInnerTRichViewEdit.GetControl: TWinControl;
begin
  Result := Self;
end;

{------------------------------------------------------------------------------}
function TcxInnerTRichViewEdit.GetControlContainer: TcxContainer;
begin
  Result := Container;
end;

{------------------------------------------------------------------------------}
function TcxInnerTRichViewEdit.GetDataClass: TRichViewRVDataClass;
begin
  Result := TcxRVData;
end;

{------------------------------------------------------------------------------}

function TcxInnerTRichViewEdit.GetDesignTimeText: String;
begin
  if Container <> nil then
    Result := Container.Name
  else
    Result := inherited GetDesignTimeText;
end;

{------------------------------------------------------------------------------}
{
 function TcxInnerTRichViewEdit.DoChanging: Boolean;
 begin
 Result := inherited DoChanging;
 if Result and (Container<>nil) then
 Result := Container.DoEditing;
 end;
}
{------------------------------------------------------------------------------}
function TcxInnerTRichViewEdit.BeforeChange(FromOutside: Boolean): Boolean;
begin
  Result := True;
  if (Container <> nil) then
    Result := Container.DoEditing;
  if Result then
    Result := inherited BeforeChange(FromOutside);
end;

{------------------------------------------------------------------------------}
function TcxInnerTRichViewEdit.GetHelper: IcxCustomInnerEdit;
begin
  Result := FHelper;
end;

{------------------------------------------------------------------------------}
procedure TcxInnerTRichViewEdit.KeyDown(var Key: Word; Shift: TShiftState);
begin
  if (Container <> nil) and
    not((Key = VK_RETURN) and not(rvoDoNotWantReturns in EditorOptions)) then
    Container.KeyDown(Key, Shift);
  if Key <> 0 then
    inherited;
end;

{------------------------------------------------------------------------------}
procedure TcxInnerTRichViewEdit.KeyPress(var Key: Char);
begin
  if Container <> nil then
    Container.KeyPress(Key);
  if Key <> #0 then
    inherited;
end;

{------------------------------------------------------------------------------}
procedure TcxInnerTRichViewEdit.KeyUp(var Key: Word; Shift: TShiftState);
begin
  if Container <> nil then
    Container.KeyUp(Key, Shift);
  if Key <> 0 then
    inherited;
end;

{------------------------------------------------------------------------------}
procedure TcxInnerTRichViewEdit.MouseDown(Button: TMouseButton;
  Shift: TShiftState; X, Y: Integer);
var
  pt: TPoint;
begin
  if Container <> nil then
  begin
    pt := ClientToParent(Point(X, Y), Container);
    Container.MouseDown(Button, Shift, X, Y);
  end;
  inherited;
end;

{------------------------------------------------------------------------------}
procedure TcxInnerTRichViewEdit.MouseMove(Shift: TShiftState; X, Y: Integer);
var
  pt: TPoint;
begin
  if Container <> nil then
  begin
    pt := ClientToParent(Point(X, Y), Container);
    Container.MouseMove(Shift, X, Y);
  end;
  inherited;
end;

{------------------------------------------------------------------------------}
procedure TcxInnerTRichViewEdit.MouseUp(Button: TMouseButton;
  Shift: TShiftState; X, Y: Integer);
var
  pt: TPoint;
begin
  if Container <> nil then
  begin
    pt := ClientToParent(Point(X, Y), Container);
    Container.MouseUp(Button, Shift, X, Y);
  end;
  inherited;
end;

{------------------------------------------------------------------------------}
procedure TcxInnerTRichViewEdit.DblClick;
begin
  if Container <> nil then
    Container.DblClick;
  inherited;
end;

{------------------------------------------------------------------------------}
procedure TcxInnerTRichViewEdit.SetBounds(ALeft, ATop, AWidth,
  AHeight: Integer);
begin
  if not FIsCreating and (FLockBoundsCount = 0) then
  begin
    Container.LockAlignControls(True);
    try
      inherited SetBounds(ALeft, ATop, AWidth, AHeight);
    finally
      Container.LockAlignControls(False);
    end;
  end;
end;

{------------------------------------------------------------------------------}
procedure TcxInnerTRichViewEdit.WMWindowPosChanged
  (var Message: TWMWindowPosChanged);
begin
  if not FUpdatingScrollbars then
    Container.SetScrollBarsParameters;
  inherited;
end;

{------------------------------------------------------------------------------}
procedure TcxInnerTRichViewEdit.WMWindowPosChanging
  (var Message: TWMWindowPosChanging);
begin
  inherited;
  if not FUpdatingScrollbars then
    Container.SetScrollBarsParameters;
end;

{------------------------------------------------------------------------------}
procedure TcxInnerTRichViewEdit.WMContextMenu(var Message: TMessage);
begin
  PostMessage(Container.Handle, WM_CONTEXTMENU, Handle, Message.LParam);
end;

{=============================== TcxCustomTRichViewEdit ===========================}
constructor TcxCustomTRichViewEdit.Create(AOwner: TComponent);
begin
  inherited;
  FOldScrollBars := ssNone;
  ParentShowHint := True;
end;

{------------------------------------------------------------------------------}
destructor TcxCustomTRichViewEdit.Destroy;
begin
  FreeAndNil(FEditPopupMenu);
  inherited;
end;

{------------------------------------------------------------------------------}
function TcxCustomTRichViewEdit.CanAutoSize: Boolean;
begin
  Result := not IsInplace and (ActiveProperties.VisibleLineCount > 0);
end;

{------------------------------------------------------------------------------}
procedure TcxCustomTRichViewEdit.ChangeHandler(Sender: TObject);
begin
  inherited ChangeHandler(Sender);
  DoEditValueChanged;
end;

{------------------------------------------------------------------------------}
procedure TcxCustomTRichViewEdit.DoAddStyle(Sender: TCustomRichView;
  StyleInfo: TCustomRVInfo);
begin
  if Properties <> nil then
    with Properties do
      if Assigned(OnAddStyle) then
        OnAddStyle(Sender, StyleInfo);
  if RepositoryItem <> nil then
    with ActiveProperties do
      if Assigned(OnAddStyle) then
        OnAddStyle(Sender, StyleInfo);
end;

{------------------------------------------------------------------------------}
procedure TcxCustomTRichViewEdit.DoCaretGetOut(Sender: TCustomRichViewEdit;
  Direction: TRVGetOutDirection);
begin
  if Properties <> nil then
    with Properties do
      if Assigned(OnCaretGetOut) then
        OnCaretGetOut(Sender, Direction);
  if RepositoryItem <> nil then
    with ActiveProperties do
      if Assigned(OnCaretGetOut) then
        OnCaretGetOut(Sender, Direction);
end;

{------------------------------------------------------------------------------}
procedure TcxCustomTRichViewEdit.DoCaretMove(Sender: TObject);
begin
  if Properties <> nil then
    with Properties do
      if Assigned(OnCaretMove) then
        OnCaretMove(Sender);
  if RepositoryItem <> nil then
    with ActiveProperties do
      if Assigned(OnCaretMove) then
        OnCaretMove(Sender);
end;

{------------------------------------------------------------------------------}
procedure TcxCustomTRichViewEdit.DoControlAction(Sender: TCustomRichView;
  ControlAction: TRVControlAction; ItemNo: Integer; var ctrl: TControl);
begin
  if Properties <> nil then
    with Properties do
      if Assigned(OnControlAction) then
        OnControlAction(Sender, ControlAction, ItemNo, ctrl);
  if RepositoryItem <> nil then
    with ActiveProperties do
      if Assigned(OnControlAction) then
        OnControlAction(Sender, ControlAction, ItemNo, ctrl);
end;

{------------------------------------------------------------------------------}
procedure TcxCustomTRichViewEdit.DoCopy(Sender: TObject);
begin
  if Properties <> nil then
    with Properties do
      if Assigned(OnCopy) then
        OnCopy(Sender);
  if RepositoryItem <> nil then
    with ActiveProperties do
      if Assigned(OnCopy) then
        OnCopy(Sender);
end;

{------------------------------------------------------------------------------}
procedure TcxCustomTRichViewEdit.DoCurParaStyleChanged(Sender: TObject);
begin
  if Properties <> nil then
    with Properties do
      if Assigned(OnCurParaStyleChanged) then
        OnCurParaStyleChanged(Sender);
  if RepositoryItem <> nil then
    with ActiveProperties do
      if Assigned(OnCurParaStyleChanged) then
        OnCurParaStyleChanged(Sender);
end;

{------------------------------------------------------------------------------}
procedure TcxCustomTRichViewEdit.DoCurTextStyleChanged(Sender: TObject);
begin
  if Properties <> nil then
    with Properties do
      if Assigned(OnCurTextStyleChanged) then
        OnCurTextStyleChanged(Sender);
  if RepositoryItem <> nil then
    with ActiveProperties do
      if Assigned(OnCurTextStyleChanged) then
        OnCurTextStyleChanged(Sender);
end;

{------------------------------------------------------------------------------}
procedure TcxCustomTRichViewEdit.DoDrawCustomCaret(Sender: TCustomRichViewEdit;
  Canvas: TCanvas; const Rect: TRect);
var
  HasRepoEvent: Boolean;
begin
  HasRepoEvent := (RepositoryItem <> nil) and
    Assigned(ActiveProperties.OnDrawCustomCaret);
  if not HasRepoEvent and (Properties <> nil) then
    with Properties do
      if Assigned(OnDrawCustomCaret) then
        OnDrawCustomCaret(Sender, Canvas, Rect);
  if RepositoryItem <> nil then
    with ActiveProperties do
      if Assigned(OnDrawCustomCaret) then
        OnDrawCustomCaret(Sender, Canvas, Rect);
end;

{------------------------------------------------------------------------------}
procedure TcxCustomTRichViewEdit.DoDropFiles(Sender: TCustomRichViewEdit;
  Files: TStrings; var FileAction: TRVDropFileAction; var DoDefault: Boolean);
begin
  if RepositoryItem <> nil then
    with ActiveProperties do
      if Assigned(OnDropFiles) then
        OnDropFiles(Sender, Files, FileAction, DoDefault);
  if DoDefault and (Properties <> nil) then
    with Properties do
      if Assigned(OnDropFiles) then
        OnDropFiles(Sender, Files, FileAction, DoDefault);
end;

{------------------------------------------------------------------------------}
procedure TcxCustomTRichViewEdit.DoGetItemCursor(Sender: TCustomRichView;
  RVData: TCustomRVData; ItemNo: Integer; var Cursor: TCursor);
var
  HasRepoEvent: Boolean;
begin
  HasRepoEvent := (RepositoryItem <> nil) and
    Assigned(ActiveProperties.OnGetItemCursor);
  if not HasRepoEvent and (Properties <> nil) then
    with Properties do
      if Assigned(OnGetItemCursor) then
        OnGetItemCursor(Sender, RVData, ItemNo, Cursor);
  if RepositoryItem <> nil then
    with ActiveProperties do
      if Assigned(OnGetItemCursor) then
        OnGetItemCursor(Sender, RVData, ItemNo, Cursor);
end;

{------------------------------------------------------------------------------}
procedure TcxCustomTRichViewEdit.DoImportPicture(Sender: TCustomRichView;
  const Location: String; Width, Height: Integer; var Graphic: TGraphic);
begin
  if RepositoryItem <> nil then
    with ActiveProperties do
      if Assigned(OnImportPicture) then
        OnImportPicture(Sender, Location, Width, Height, Graphic);
  if (Graphic = nil) and (Properties <> nil) then
    with Properties do
      if Assigned(OnImportPicture) then
        OnImportPicture(Sender, Location, Width, Height, Graphic);
end;

{------------------------------------------------------------------------------}
procedure TcxCustomTRichViewEdit.DoItemAction(Sender: TCustomRichView;
  ItemAction: TRVItemAction; Item: TCustomRVItemInfo;
  var Text: TRVRawByteString; RVData: TCustomRVData);
begin
  if Properties <> nil then
    with Properties do
      if Assigned(OnItemAction) then
        OnItemAction(Sender, ItemAction, Item, Text, RVData);
  if RepositoryItem <> nil then
    with ActiveProperties do
      if Assigned(OnItemAction) then
        OnItemAction(Sender, ItemAction, Item, Text, RVData);
end;

{------------------------------------------------------------------------------}
procedure TcxCustomTRichViewEdit.DoItemHint(Sender: TCustomRichView;
  RVData: TCustomRVData; ItemNo: Integer; var HintText: String);
begin
  if Properties <> nil then
    with Properties do
      if Assigned(OnItemHint) then
        OnItemHint(Sender, RVData, ItemNo, HintText);
  if RepositoryItem <> nil then
    with ActiveProperties do
      if Assigned(OnItemHint) then
        OnItemHint(Sender, RVData, ItemNo, HintText);
end;

{------------------------------------------------------------------------------}
procedure TcxCustomTRichViewEdit.DoItemResize(Sender: TCustomRichViewEdit;
  RVData: TCustomRVFormattedData; ItemNo, Val1, Val2: Integer);
begin
  if Properties <> nil then
    with Properties do
      if Assigned(OnItemResize) then
        OnItemResize(Sender, RVData, ItemNo, Val1, Val2);
  if RepositoryItem <> nil then
    with ActiveProperties do
      if Assigned(OnItemResize) then
        OnItemResize(Sender, RVData, ItemNo, Val1, Val2);
end;

{------------------------------------------------------------------------------}
procedure TcxCustomTRichViewEdit.DoLoadValue(Sender: TObject);
begin
  if Properties <> nil then
    with Properties do
      if Assigned(OnLoadValue) then
        OnLoadValue(Self);
  if RepositoryItem <> nil then
    with ActiveProperties do
      if Assigned(OnLoadValue) then
        OnLoadValue(Self);
end;

{------------------------------------------------------------------------------}
procedure TcxCustomTRichViewEdit.DoItemTextEdit(Sender: TCustomRichViewEdit;
  const OldText: TRVRawByteString; RVData: TCustomRVData; ItemNo: Integer;
  var NewTag: TRVTag; var NewStyleNo: Integer);
var
  HasRepoEvent: Boolean;
begin
  HasRepoEvent := (RepositoryItem <> nil) and
    Assigned(ActiveProperties.OnItemTextEdit);
  if not HasRepoEvent and (Properties <> nil) then
    with Properties do
      if Assigned(OnItemTextEdit) then
        OnItemTextEdit(Sender, OldText, RVData, ItemNo, NewTag, NewStyleNo);
  if RepositoryItem <> nil then
    with ActiveProperties do
      if Assigned(OnItemTextEdit) then
        OnItemTextEdit(Sender, OldText, RVData, ItemNo, NewTag, NewStyleNo);
end;

{------------------------------------------------------------------------------}
procedure TcxCustomTRichViewEdit.DoJump(Sender: TObject; id: Integer);
var
  HasRepoEvent: Boolean;
begin
  HasRepoEvent := (RepositoryItem <> nil) and Assigned(ActiveProperties.OnJump);
  if not HasRepoEvent and (Properties <> nil) then
    with Properties do
      if Assigned(OnJump) then
        OnJump(Sender, id);
  if RepositoryItem <> nil then
    with ActiveProperties do
      if Assigned(OnJump) then
        OnJump(Sender, id);
end;

{------------------------------------------------------------------------------}
procedure TcxCustomTRichViewEdit.DoMeasureCustomCaret
  (Sender: TCustomRichViewEdit; var Rect: TRect);
var
  HasRepoEvent: Boolean;
begin
  HasRepoEvent := (RepositoryItem <> nil) and
    Assigned(ActiveProperties.OnMeasureCustomCaret);
  if not HasRepoEvent and (Properties <> nil) then
    with Properties do
      if Assigned(OnMeasureCustomCaret) then
        OnMeasureCustomCaret(Sender, Rect);
  if RepositoryItem <> nil then
    with ActiveProperties do
      if Assigned(OnMeasureCustomCaret) then
        OnMeasureCustomCaret(Sender, Rect);
end;

{------------------------------------------------------------------------------}
procedure TcxCustomTRichViewEdit.DoHTMLSaveImage(Sender: TCustomRichView;
  RVData: TCustomRVData; ItemNo: Integer; const Path: String;
  BackgroundColor: TColor; var Location: String; var DoDefault: Boolean);
begin
  if RepositoryItem <> nil then
    with ActiveProperties do
      if Assigned(OnHTMLSaveImage) then
        OnHTMLSaveImage(Sender, RVData, ItemNo, Path, BackgroundColor, Location,
          DoDefault);
  if DoDefault and (Properties <> nil) then
    with Properties do
      if Assigned(OnHTMLSaveImage) then
        OnHTMLSaveImage(Sender, RVData, ItemNo, Path, BackgroundColor, Location,
          DoDefault);
end;

{------------------------------------------------------------------------------}
procedure TcxCustomTRichViewEdit.DoPaint_(Sender: TCustomRichView;
  Canvas: TCanvas; Prepaint: Boolean);
begin
  if Properties <> nil then
    with Properties do
      if Assigned(OnPaint) then
        OnPaint(Sender, Canvas, Prepaint);
  if RepositoryItem <> nil then
    with ActiveProperties do
      if Assigned(OnPaint) then
        OnPaint(Sender, Canvas, Prepaint);
end;

{------------------------------------------------------------------------------}
procedure TcxCustomTRichViewEdit.DoParaStyleConversion
  (Sender: TCustomRichViewEdit; StyleNo, UserData: Integer;
  AppliedToText: Boolean; var NewStyleNo: Integer);
var
  HasRepoEvent: Boolean;
begin
  HasRepoEvent := (RepositoryItem <> nil) and
    Assigned(ActiveProperties.OnParaStyleConversion);
  if not HasRepoEvent and (Properties <> nil) then
    with Properties do
      if Assigned(OnParaStyleConversion) then
        OnParaStyleConversion(Sender, StyleNo, UserData, AppliedToText,
          NewStyleNo);
  if RepositoryItem <> nil then
    with ActiveProperties do
      if Assigned(OnParaStyleConversion) then
        OnParaStyleConversion(Sender, StyleNo, UserData, AppliedToText,
          NewStyleNo);
end;

{------------------------------------------------------------------------------}
procedure TcxCustomTRichViewEdit.DoProgress(Sender: TCustomRichView;
  Operation: TRVLongOperation; Stage: TRVProgressStage; PercentDone: Byte);
begin
  if Properties <> nil then
    with Properties do
      if Assigned(OnProgress) then
        OnProgress(Sender, Operation, Stage, PercentDone);
  if RepositoryItem <> nil then
    with ActiveProperties do
      if Assigned(OnProgress) then
        OnProgress(Sender, Operation, Stage, PercentDone);
end;

{------------------------------------------------------------------------------}
procedure TcxCustomTRichViewEdit.DoReadHyperlink(Sender: TCustomRichView;
  const Target, Extras: String; DocFormat: TRVLoadFormat; var StyleNo: Integer;
  var ItemTag: TRVTag; var ItemName: TRVRawByteString);
var
  HasRepoEvent: Boolean;
begin
  HasRepoEvent := (RepositoryItem <> nil) and
    Assigned(ActiveProperties.OnReadHyperlink);
  if not HasRepoEvent and (Properties <> nil) then
    with Properties do
      if Assigned(OnReadHyperlink) then
        OnReadHyperlink(Sender, Target, Extras, DocFormat, StyleNo, ItemTag,
          ItemName);
  if RepositoryItem <> nil then
    with ActiveProperties do
      if Assigned(OnReadHyperlink) then
        OnReadHyperlink(Sender, Target, Extras, DocFormat, StyleNo, ItemTag,
          ItemName);
end;

{------------------------------------------------------------------------------}
procedure TcxCustomTRichViewEdit.DoRVDblClick(Sender: TCustomRichView;
  ClickedWord: TRVRawByteString; Style: Integer);
var
  HasRepoEvent: Boolean;
begin
  HasRepoEvent := (RepositoryItem <> nil) and
    Assigned(ActiveProperties.OnRVDblClick);
  if not HasRepoEvent and (Properties <> nil) then
    with Properties do
      if Assigned(OnRVDblClick) then
        OnRVDblClick(Sender, ClickedWord, Style);
  if RepositoryItem <> nil then
    with ActiveProperties do
      if Assigned(OnRVDblClick) then
        OnRVDblClick(Sender, ClickedWord, Style);
end;

{------------------------------------------------------------------------------}
procedure TcxCustomTRichViewEdit.DoRVFControlNeeded(Sender: TCustomRichView;
  Name: String; const Tag: TRVTag; var ctrl: TControl);
begin
  if (RepositoryItem <> nil) then
    with ActiveProperties do
      if Assigned(OnRVFControlNeeded) then
        OnRVFControlNeeded(Sender, Name, Tag, ctrl);
  if (ctrl = nil) and (Properties <> nil) then
    with Properties do
      if Assigned(OnRVFControlNeeded) then
        OnRVFControlNeeded(Sender, Name, Tag, ctrl);
end;

{------------------------------------------------------------------------------}
procedure TcxCustomTRichViewEdit.DoRVFImageListNeeded(Sender: TCustomRichView;
  ImageListTag: Integer; var il: TCustomImageList);
begin
  if RepositoryItem <> nil then
    with ActiveProperties do
      if Assigned(OnRVFImageListNeeded) then
        OnRVFImageListNeeded(Sender, ImageListTag, il);
  if (il = nil) and (Properties <> nil) then
    with Properties do
      if Assigned(OnRVFImageListNeeded) then
        OnRVFImageListNeeded(Sender, ImageListTag, il);
end;

{------------------------------------------------------------------------------}
procedure TcxCustomTRichViewEdit.DoRVFPictureNeeded(Sender: TCustomRichView;
  const ItemName: String; Item: TRVNonTextItemInfo; Index1, Index2: Integer;
  var gr: TGraphic);
begin
  if RepositoryItem <> nil then
    with ActiveProperties do
      if Assigned(OnRVFPictureNeeded) then
        OnRVFPictureNeeded(Sender, ItemName, Item, Index1, Index2, gr);
  if (gr = nil) and (Properties <> nil) then
    with Properties do
      if Assigned(OnRVFPictureNeeded) then
        OnRVFPictureNeeded(Sender, ItemName, Item, Index1, Index2, gr);
end;

{------------------------------------------------------------------------------}
procedure TcxCustomTRichViewEdit.DoRVMouseDown(Sender: TCustomRichView;
  Button: TMouseButton; Shift: TShiftState; ItemNo, X, Y: Integer);
var
  HasRepoEvent: Boolean;
begin
  HasRepoEvent := (RepositoryItem <> nil) and
    Assigned(ActiveProperties.OnRVMouseDown);
  if not HasRepoEvent and (Properties <> nil) then
    with Properties do
      if Assigned(OnRVMouseDown) then
        OnRVMouseDown(Sender, Button, Shift, ItemNo, X, Y);
  if RepositoryItem <> nil then
    with ActiveProperties do
      if Assigned(OnRVMouseDown) then
        OnRVMouseDown(Sender, Button, Shift, ItemNo, X, Y);
end;

{------------------------------------------------------------------------------}
procedure TcxCustomTRichViewEdit.DoRVMouseUp(Sender: TCustomRichView;
  Button: TMouseButton; Shift: TShiftState; ItemNo, X, Y: Integer);
var
  HasRepoEvent: Boolean;
begin
  HasRepoEvent := (RepositoryItem <> nil) and
    Assigned(ActiveProperties.OnRVMouseUp);
  if not HasRepoEvent and (Properties <> nil) then
    with Properties do
      if Assigned(OnRVMouseUp) then
        OnRVMouseUp(Sender, Button, Shift, ItemNo, X, Y);
  if RepositoryItem <> nil then
    with ActiveProperties do
      if Assigned(OnRVMouseUp) then
        OnRVMouseUp(Sender, Button, Shift, ItemNo, X, Y);
end;

{------------------------------------------------------------------------------}
procedure TcxCustomTRichViewEdit.DoRVMouseMoveEvent(Sender: TObject;
  id: Integer);
var
  HasRepoEvent: Boolean;
begin
  HasRepoEvent := (RepositoryItem <> nil) and
    Assigned(ActiveProperties.OnRVMouseMove);
  if not HasRepoEvent and (Properties <> nil) then
    with Properties do
      if Assigned(OnRVMouseMove) then
        OnRVMouseMove(Sender, id);
  if RepositoryItem <> nil then
    with ActiveProperties do
      if Assigned(OnRVMouseMove) then
        OnRVMouseMove(Sender, id);
end;

{------------------------------------------------------------------------------}
procedure TcxCustomTRichViewEdit.DoSaveComponentToFile(Sender: TCustomRichView;
  Path: String; SaveMe: TPersistent; SaveFormat: TRVSaveFormat;
  var OutStr: String);
begin
  if RepositoryItem <> nil then
    with ActiveProperties do
      if Assigned(OnSaveComponentToFile) then
        OnSaveComponentToFile(Sender, Path, SaveMe, SaveFormat, OutStr);
  if (OutStr = '') and (Properties <> nil) then
    with Properties do
      if Assigned(OnSaveComponentToFile) then
        OnSaveComponentToFile(Sender, Path, SaveMe, SaveFormat, OutStr);
end;

{------------------------------------------------------------------------------}
procedure TcxCustomTRichViewEdit.DoSaveHTMLExtra(Sender: TCustomRichView;
  Area: TRVHTMLSaveArea; CSSVersion: Boolean; var HTMLCode: String);
var
  HasRepoEvent: Boolean;
begin
  HasRepoEvent := (RepositoryItem <> nil) and
    Assigned(ActiveProperties.OnSaveHTMLExtra);
  if not HasRepoEvent and (Properties <> nil) then
    with Properties do
      if Assigned(OnSaveHTMLExtra) then
        OnSaveHTMLExtra(Sender, Area, CSSVersion, HTMLCode);
  if RepositoryItem <> nil then
    with ActiveProperties do
      if Assigned(OnSaveHTMLExtra) then
        OnSaveHTMLExtra(Sender, Area, CSSVersion, HTMLCode);
end;

{------------------------------------------------------------------------------}
procedure TcxCustomTRichViewEdit.DoSaveImage2(Sender: TCustomRichView;
  Graphic: TGraphic; SaveFormat: TRVSaveFormat; const Path, ImagePrefix: String;
  var ImageSaveNo: Integer; var Location: String; var DoDefault: Boolean);
begin
  if RepositoryItem <> nil then
    with ActiveProperties do
      if Assigned(OnSaveImage2) then
        OnSaveImage2(Sender, Graphic, SaveFormat, Path, ImagePrefix,
          ImageSaveNo, Location, DoDefault);
  if DoDefault and (Properties <> nil) then
    with Properties do
      if Assigned(OnSaveImage2) then
        OnSaveImage2(Sender, Graphic, SaveFormat, Path, ImagePrefix,
          ImageSaveNo, Location, DoDefault);
end;

{------------------------------------------------------------------------------}
procedure TcxCustomTRichViewEdit.DoSaveItemToFile(Sender: TCustomRichView;
  const Path: String; RVData: TCustomRVData; ItemNo: Integer;
  SaveFormat: TRVSaveFormat; Unicode: Boolean; var OutStr: TRVRawByteString;
  var DoDefault: Boolean);
begin
  if RepositoryItem <> nil then
    with ActiveProperties do
      if Assigned(OnSaveItemToFile) then
        OnSaveItemToFile(Sender, Path, RVData, ItemNo, SaveFormat, Unicode,
          OutStr, DoDefault);
  if DoDefault and (Properties <> nil) then
    with Properties do
      if Assigned(OnSaveItemToFile) then
        OnSaveItemToFile(Sender, Path, RVData, ItemNo, SaveFormat, Unicode,
          OutStr, DoDefault);
end;

{------------------------------------------------------------------------------}
procedure TcxCustomTRichViewEdit.DoSaveRTFExtra(Sender: TCustomRichView;
  Area: TRVRTFSaveArea; Obj: TObject; Index1, Index2: Integer;
  InStyleSheet: Boolean; var RTFCode: TRVAnsiString);
begin
  if RepositoryItem <> nil then
    with ActiveProperties do
      if Assigned(OnSaveRTFExtra) then
        OnSaveRTFExtra(Sender, Area, Obj, Index1, Index2, InStyleSheet,
          RTFCode);
  if (RTFCode = '') and (Properties <> nil) then
    with Properties do
      if Assigned(OnSaveRTFExtra) then
        OnSaveRTFExtra(Sender, Area, Obj, Index1, Index2, InStyleSheet,
          RTFCode);
end;

{------------------------------------------------------------------------------}
procedure TcxCustomTRichViewEdit.DoSelect(Sender: TObject);
begin
  if RepositoryItem <> nil then
    with ActiveProperties do
      if Assigned(OnSelect) then
        OnSelect(Sender);
  if Properties <> nil then
    with Properties do
      if Assigned(OnSelect) then
        OnSelect(Sender);
end;
{------------------------------------------------------------------------------}
{$IFNDEF RVDONOTUSELIVESPELL}

procedure TcxCustomTRichViewEdit.DoSpellingCheck(Sender: TCustomRichView;
  const AWord: String; StyleNo: Integer; var Misspelled: Boolean);
var
  HasRepoEvent: Boolean;
begin
  HasRepoEvent := (RepositoryItem <> nil) and
    Assigned(ActiveProperties.OnSpellingCheck);
  if not HasRepoEvent and (Properties <> nil) then
    with Properties do
      if Assigned(OnSpellingCheck) then
        OnSpellingCheck(Sender, AWord, StyleNo, Misspelled);
  if RepositoryItem <> nil then
    with ActiveProperties do
      if Assigned(OnSpellingCheck) then
        OnSpellingCheck(Sender, AWord, StyleNo, Misspelled);
end;
{$ENDIF}

{------------------------------------------------------------------------------}
procedure TcxCustomTRichViewEdit.DoStyleConversion(Sender: TCustomRichViewEdit;
  StyleNo, UserData: Integer; AppliedToText: Boolean; var NewStyleNo: Integer);
var
  HasRepoEvent: Boolean;
begin
  HasRepoEvent := (RepositoryItem <> nil) and
    Assigned(ActiveProperties.OnStyleConversion);
  if not HasRepoEvent and (Properties <> nil) then
    with Properties do
      if Assigned(OnStyleConversion) then
        OnStyleConversion(Sender, StyleNo, UserData, AppliedToText, NewStyleNo);
  if RepositoryItem <> nil then
    with ActiveProperties do
      if Assigned(OnStyleConversion) then
        OnStyleConversion(Sender, StyleNo, UserData, AppliedToText, NewStyleNo);
end;

{------------------------------------------------------------------------------}
procedure TcxCustomTRichViewEdit.DoWriteHyperlink(Sender: TCustomRichView;
  id: Integer; RVData: TCustomRVData; ItemNo: Integer;
  SaveFormat: TRVSaveFormat; var Target, Extras: String);
var
  HasRepoEvent: Boolean;
begin
  HasRepoEvent := (RepositoryItem <> nil) and
    Assigned(ActiveProperties.OnWriteHyperlink);
  if not HasRepoEvent and (Properties <> nil) then
    with Properties do
      if Assigned(OnWriteHyperlink) then
        OnWriteHyperlink(Sender, id, RVData, ItemNo, SaveFormat,
          Target, Extras);
  if RepositoryItem <> nil then
    with ActiveProperties do
      if Assigned(OnWriteHyperlink) then
        OnWriteHyperlink(Sender, id, RVData, ItemNo, SaveFormat,
          Target, Extras);
end;

{------------------------------------------------------------------------------}
function TcxCustomTRichViewEdit.GetInnerEditClass: TControlClass;
begin
  Result := TcxInnerTRichViewEdit;
end;

{------------------------------------------------------------------------------}
function TcxCustomTRichViewEdit.GetInnerEditor: TcxInnerTRichViewEdit;
begin
  Result := TcxInnerTRichViewEdit(InnerControl);
end;

{------------------------------------------------------------------------------}
procedure TcxCustomTRichViewEdit.Initialize;
begin
  inherited Initialize;
  InnerEditor.OnAddStyle := DoAddStyle;
  InnerEditor.OnCopy := DoCopy;
  InnerEditor.OnControlAction := DoControlAction;
  InnerEditor.OnGetItemCursor := DoGetItemCursor;
  InnerEditor.OnImportPicture := DoImportPicture;
  InnerEditor.OnItemAction := DoItemAction;
  InnerEditor.OnItemHint := DoItemHint;
  InnerEditor.OnJump := DoJump;
  InnerEditor.OnHTMLSaveImage := DoHTMLSaveImage;
  InnerEditor.OnPaint := DoPaint_;
  InnerEditor.OnProgress := DoProgress;
  InnerEditor.OnReadHyperlink := DoReadHyperlink;
  InnerEditor.OnRVDblClick := DoRVDblClick;
  InnerEditor.OnRVFImageListNeeded := DoRVFImageListNeeded;
  InnerEditor.OnRVFControlNeeded := DoRVFControlNeeded;
  InnerEditor.OnRVFPictureNeeded := DoRVFPictureNeeded;
  InnerEditor.OnRVMouseDown := DoRVMouseDown;
  InnerEditor.OnRVMouseMove := DoRVMouseMoveEvent;
  InnerEditor.OnRVMouseUp := DoRVMouseUp;
  InnerEditor.OnSaveComponentToFile := DoSaveComponentToFile;
  InnerEditor.OnSaveHTMLExtra := DoSaveHTMLExtra;
  InnerEditor.OnSaveImage2 := DoSaveImage2;
  InnerEditor.OnSaveItemToFile := DoSaveItemToFile;
  InnerEditor.OnSaveRTFExtra := DoSaveRTFExtra;
  InnerEditor.OnSelect := DoSelect;
  {$IFNDEF RVDONOTUSELIVESPELL}
  InnerEditor.OnSpellingCheck := DoSpellingCheck;
  {$ENDIF}
  InnerEditor.OnWriteHyperlink := DoWriteHyperlink;
  InnerEditor.OnCaretGetOut := DoCaretGetOut;
  InnerEditor.OnCaretMove := DoCaretMove;
  InnerEditor.OnDropFiles := DoDropFiles;
  InnerEditor.OnParaStyleConversion := DoParaStyleConversion;
  InnerEditor.OnStyleConversion := DoStyleConversion;
  InnerEditor.OnCurParaStyleChanged := DoCurParaStyleChanged;
  InnerEditor.OnCurTextStyleChanged := DoCurTextStyleChanged;
  InnerEditor.OnItemTextEdit := DoItemTextEdit;
  InnerEditor.OnDrawCustomCaret := DoDrawCustomCaret;
  InnerEditor.OnMeasureCustomCaret := DoMeasureCustomCaret;
  InnerEditor.OnItemResize := DoItemResize;
  Width := 185;
  Height := 89;
end;

{------------------------------------------------------------------------------}
procedure TcxCustomTRichViewEdit.AdjustInnerEditPosition;
var
  r, AInnerEditBounds: TRect;

begin
  inherited;
  if (InnerEditor = nil) or FInnerEditPositionAdjusting then
    exit;
  FInnerEditPositionAdjusting := True;
  try
    (*
     R := Bounds;
     OffsetRect(R, -R.Left, -R.Top);
     InflateRect(R, -cxContainerMaxBorderWidth, -cxContainerMaxBorderWidth);
     {
     R := ViewInfo.ClientRect;
     AInnerEditBounds := Rect(R.Left - cxContainerMaxBorderWidth, R.Top - cxContainerMaxBorderWidth,
     R.Right - R.Left + cxContainerMaxBorderWidth * 2, R.Bottom - R.Top + cxContainerMaxBorderWidth * 2);
     }
     with R do
     if not EqualRect(InnerEdit.Control.BoundsRect, Rect(Left, Top, Left + Right, Top + Bottom)) then
     InnerEdit.Control.SetBounds(Left, Top, Right, Bottom);
    *)
    r := ViewInfo.ClientRect;
    AInnerEditBounds := r;
    if not ViewInfo.IsInplace then
      InflateRect(AInnerEditBounds, cxContainerMaxBorderWidth,
        cxContainerMaxBorderWidth);
    if ViewInfo.IsInplace then
      InnerEditor.VSmallStep := 1
    else
      InnerEditor.VSmallStep := InnerEditor.GetDefSmallStep;
    with AInnerEditBounds do
      if not EqualRect(InnerEdit.Control.BoundsRect,
        Rect(Left, Top, Left + Right, Top + Bottom)) then
        InnerEdit.Control.SetBounds(Left, Top, Right, Bottom);
    AlignControls(InnerEdit.Control, r);
  finally
    FInnerEditPositionAdjusting := False;
  end;

end;

{------------------------------------------------------------------------------}
function TcxCustomTRichViewEdit.NeedsScrollBars: Boolean;
begin
  Result := FCanCreateScrollBars and (ActiveProperties <> nil) and
    (ActiveProperties.ScrollBars <> ssNone);
end;

{------------------------------------------------------------------------------}
procedure TcxCustomTRichViewEdit.PropertiesChanged(Sender: TObject);
begin
  if PropertiesChangeLocked then
    exit;
  if FOldScrollBars <> ActiveProperties.ScrollBars then
  begin
    if InnerEditor <> nil then
    begin
      FCanCreateScrollBars := True;
      InnerEditor.FUpdatingScrollbars := True;
      try
        InnerEditor.VScrollVisible := ActiveProperties.ScrollBars
          in [ssVertical, ssBoth];
        InnerEditor.HScrollVisible := ActiveProperties.ScrollBars
          in [ssHorizontal, ssBoth];
      finally
        InnerEditor.FUpdatingScrollbars := False;
      end;
    end;
    CheckNeedsScrollBars;
    FOldScrollBars := ActiveProperties.ScrollBars;
    if HandleAllocated then
      RecreateWnd;
  end;
  with ActiveProperties do
  begin
    AssignToTRichView(InnerEditor);

    InnerEditor.AcceptDragDropFormats := AcceptDragDropFormats;
    InnerEditor.CustomCaretInterval := CustomCaretInterval;
    InnerEditor.EditorOptions := EditorOptions;
    InnerEditor.UndoLimit := UndoLimit;
    (*
     InnerEditor.OnAddStyle := OnAddStyle;
     InnerEditor.OnControlAction := OnControlAction;
     InnerEditor.OnCopy := OnCopy;
     InnerEditor.OnGetItemCursor := OnGetItemCursor;
     InnerEditor.OnImportPicture := OnImportPicture;
     InnerEditor.OnItemAction := OnItemAction;
     InnerEditor.OnItemHint := OnItemHint;
     InnerEditor.OnJump := OnJump;
     InnerEditor.OnHTMLSaveImage := OnHTMLSaveImage;
     InnerEditor.OnPaint := OnPaint;
     InnerEditor.OnProgress := OnProgress;
     InnerEditor.OnReadHyperlink := OnReadHyperlink;
     InnerEditor.OnRVDblClick := OnRVDblClick;
     InnerEditor.OnRVFImageListNeeded := OnRVFImageListNeeded;
     InnerEditor.OnRVFControlNeeded := OnRVFControlNeeded;
     InnerEditor.OnRVFPictureNeeded := OnRVFPictureNeeded;
     InnerEditor.OnRVMouseDown := OnRVMouseDown;
     InnerEditor.OnRVMouseMove := OnRVMouseMove;
     InnerEditor.OnRVMouseUp := OnRVMouseUp;
     InnerEditor.OnSaveComponentToFile := OnSaveComponentToFile;
     InnerEditor.OnSaveHTMLExtra := OnSaveHTMLExtra;
     InnerEditor.OnSaveImage2 := OnSaveImage2;
     InnerEditor.OnSaveItemToFile := OnSaveItemToFile;
     InnerEditor.OnSaveRTFExtra := OnSaveRTFExtra;
     InnerEditor.OnSelect := OnSelect;
     {$IFNDEF RVDONOTUSELIVESPELL}
     InnerEditor.OnSpellingCheck := OnSpellingCheck;
     {$ENDIF}
     InnerEditor.OnWriteHyperlink := OnWriteHyperlink;

     InnerEditor.OnCaretGetOut := OnCaretGetOut;
     InnerEditor.OnCaretMove := OnCaretMove;
     InnerEditor.OnDropFiles := OnDropFiles;
     InnerEditor.OnParaStyleConversion := OnParaStyleConversion;
     InnerEditor.OnStyleConversion := OnStyleConversion;
     InnerEditor.OnCurParaStyleChanged := OnCurParaStyleChanged;
     InnerEditor.OnCurTextStyleChanged := OnCurTextStyleChanged;
     InnerEditor.OnItemTextEdit := OnItemTextEdit;
     {$IFNDEF RVDONOTUSEDRAGDROP}
     {
     InnerEditor.OnOleDragEnter := OnOleDragEnter;
     InnerEditor.OnOleDragOver := OnOleDragOver;
     InnerEditor.OnOleDrop := OnOleDrop;
     InnerEditor.OnOleDragLeave := OnOleDragLeave;
     }
     {$ENDIF}
     InnerEditor.OnDrawCustomCaret := OnDrawCustomCaret;
     InnerEditor.OnMeasureCustomCaret := OnMeasureCustomCaret;
     InnerEditor.OnItemResize := OnItemResize;
    *)
  end;
  UpdateDrawValue;
  inherited PropertiesChanged(Sender);
  if InnerEditor <> nil then
    InnerEditor.Invalidate;
end;

{------------------------------------------------------------------------------}
function TcxCustomTRichViewEdit.DoRefreshContainer(const P: TPoint;
  Button: TcxMouseButton; Shift: TShiftState; AIsMouseEvent: Boolean): Boolean;
begin
  Result := inherited DoRefreshContainer(P, Button, Shift, AIsMouseEvent);
  if Result then
    AdjustInnerEdit;
end;

{------------------------------------------------------------------------------}
class function TcxCustomTRichViewEdit.GetPropertiesClass
  : TcxCustomEditPropertiesClass;
begin
  Result := TcxCustomRVProperties;
end;

{------------------------------------------------------------------------------}
procedure TcxCustomTRichViewEdit.InitScrollBarsParameters;
var
  HScrollPage, VScrollPage: Integer;
begin
  if InnerEditor = nil then
    exit;
  HScrollPage := InnerEditor.ClientWidth;
  SetScrollBarInfo(sbHorizontal, 0, InnerEditor.HScrollMax + (HScrollPage - 1),
    1, HScrollPage, InnerEditor.HScrollPos, InnerEditor.HScrollVisible, True);

  // SetScrollBarInfo(, 0, 1000, 1, 100, 400, True, False);
  VScrollPage := InnerEditor.ClientHeight div InnerEditor.VSmallStep;
  SetScrollBarInfo(sbVertical, 0, InnerEditor.VScrollMax + (VScrollPage - 1), 1,
    VScrollPage, InnerEditor.VScrollPos, InnerEditor.VScrollVisible,
    not InnerEditor.VScrollVisible);
end;

{------------------------------------------------------------------------------}
function GetScrollCommand(AScrollCode: TScrollCode): Word;
begin
  case AScrollCode of
    scLineUp:
      Result := SB_LINEUP;
    scLineDown:
      Result := SB_LINEDOWN;
    scPageUp:
      Result := SB_PAGEUP;
    scPageDown:
      Result := SB_PAGEDOWN;
    scPosition:
      Result := SB_THUMBPOSITION;
    scTrack:
      Result := SB_THUMBTRACK;
    scTop:
      Result := SB_TOP;
    scBottom:
      Result := SB_BOTTOM;
    else {scEndScroll:}
      Result := SB_ENDSCROLL;
  end;
end;

{------------------------------------------------------------------------------}
function GetScrollMessage(AScrollBarKind: TScrollBarKind): Integer;
begin
  if AScrollBarKind = sbHorizontal then
    Result := WM_HSCROLL
  else
    Result := WM_VSCROLL;
end;

{------------------------------------------------------------------------------}
procedure TcxCustomTRichViewEdit.Scroll(AScrollBarKind: TScrollBarKind;
  AScrollCode: TScrollCode; var AScrollPos: Integer);
begin
  if (InnerControl <> nil) and (InnerControl.HandleAllocated) then
    InnerControl.Perform(GetScrollMessage(AScrollBarKind),
      MakeLong(GetScrollCommand(AScrollCode), Word(AScrollPos)), 0);
end;

{------------------------------------------------------------------------------}
function TcxCustomTRichViewEdit.GetActiveProperties: TcxCustomRVProperties;
begin
  Result := TcxCustomRVProperties(InternalGetActiveProperties);
end;

{------------------------------------------------------------------------------}
function TcxCustomTRichViewEdit.GetEditValue: TcxEditValue;
begin
  if InnerEditor <> nil then
    Result := InnerEditor.GetHelper.GetEditValue
  else
    Result := Null;
end;

{------------------------------------------------------------------------------}
procedure TcxCustomTRichViewEdit.InternalSetEditValue(const Value: TcxEditValue;
  AValidateEditValue: Boolean);
begin
  LockChangeEvents(True);
  try
    InnerEdit.EditValue := Value;
    EditModified := False;
  finally
    LockChangeEvents(False);
  end;
end;

{------------------------------------------------------------------------------}
procedure TcxCustomTRichViewEdit.InternalValidateDisplayValue
  (const ADisplayValue: TcxEditValue);
begin

end;

{------------------------------------------------------------------------------}
function TcxCustomTRichViewEdit.WantNavigationKeys: Boolean;
begin
  Result := True;
end;

{------------------------------------------------------------------------------}
function TcxCustomTRichViewEdit.GetProperties: TcxCustomRVProperties;
begin
  Result := TcxCustomRVProperties(FProperties);
end;

{------------------------------------------------------------------------------}
procedure TcxCustomTRichViewEdit.Notification(AComponent: TComponent;
  Operation: TOperation);
begin
  inherited;

end;

{------------------------------------------------------------------------------}
procedure TcxCustomTRichViewEdit.AdjustInnerEdit;
var
  Changed: Boolean;
begin
  if InnerEditor <> nil then
  begin
    Changed := False;
    if not ActiveProperties.IsColorStoredInDoc then
    begin
      InnerEditor.Color := ViewInfo.BackgroundColor;
      Changed := True;
    end;
    if not ActiveProperties.IsFontStoredInDoc then
    begin
      InnerEditor.Style.TextStyles[0].Color := ViewInfo.TextColor;
      Changed := True;
    end;
    if Changed then
      InnerEditor.Invalidate;
  end;
end;

{------------------------------------------------------------------------------}
function TcxCustomTRichViewEdit.GetVScrollBarBounds: TRect;
begin
  Result := inherited GetVScrollBarBounds;
  if (VScrollBar <> nil) and (VScrollBar.Visible) then
    OffsetRect(Result, -VScrollBar.Width, 0);
  if (HScrollBar <> nil) and (HScrollBar.Visible) then
    Dec(Result.Bottom, HScrollBar.Height);
end;

{------------------------------------------------------------------------------}
procedure TcxCustomTRichViewEdit.AdjustScrollBarPosition
  (AScrollBar: IcxControlScrollBar);
begin
  case AScrollBar.Kind of
    sbHorizontal:
      begin
        if InnerEditor.HScrollVisible and (InnerEditor.HScrollMax > 0) then
          AScrollBar.BoundsRect := GetHScrollBarBounds;
        AScrollBar.Enabled := InnerEditor.HScrollMax > 0;
        SetScrollBarVisible(AScrollBar, InnerEditor.HScrollVisible and
          (InnerEditor.HScrollMax > 0));
      end;
    sbVertical:
      begin
        if InnerEditor.VScrollVisible then
          AScrollBar.BoundsRect := GetVScrollBarBounds;
        AScrollBar.Enabled := InnerEditor.VScrollMax > 0;
        SetScrollBarVisible(AScrollBar, InnerEditor.VScrollVisible);
      end;
  end;
end;

{------------------------------------------------------------------------------}
function TcxCustomTRichViewEdit.GetHScrollBarBounds: TRect;
begin
  Result := inherited GetHScrollBarBounds;
  if (HScrollBar <> nil) and (HScrollBar.Visible) then
    OffsetRect(Result, 0, -HScrollBar.Height);
  if (VScrollBar <> nil) and (VScrollBar.Visible) then
    Dec(Result.Right, VScrollBar.Width);
end;

{------------------------------------------------------------------------------}
procedure TcxCustomTRichViewEdit.SetParent(AParent: TWinControl);
begin
  if AParent <> nil then
    ParentWindow := AParent.Handle;
  inherited;
  if AParent <> nil then
    ParentWindow := 0;
end;

{------------------------------------------------------------------------------}
procedure TcxCustomTRichViewEdit.SetProperties(const Value
  : TcxCustomRVProperties);
begin
  FProperties.Assign(Value);
end;

{------------------------------------------------------------------------------}
procedure TcxCustomTRichViewEdit.SynchronizeDisplayValue;
begin
  DataBinding.DisplayValue := EditValue;
end;

{------------------------------------------------------------------------------}
function TcxCustomTRichViewEdit.UpdateContentOnFocusChanging: Boolean;
begin
  Result := False;
end;

{------------------------------------------------------------------------------}
procedure TcxCustomTRichViewEdit.SetInternalDisplayValue(Value: TcxEditValue);
begin
  if InnerEdit <> nil then
    InnerEdit.EditValue := Value;
end;

{------------------------------------------------------------------------------}
procedure TcxCustomTRichViewEdit.InternalSetDisplayValue
  (const Value: TcxEditValue);
begin
  DataBinding.DisplayValue := Value;
  if not IsUserAction then
  begin
    SynchronizeEditValue;
    EditModified := False;
  end;
end;

{------------------------------------------------------------------------------}
procedure TcxCustomTRichViewEdit.Loaded;
begin
  inherited;
  ShortRefreshContainer(False);
end;

{------------------------------------------------------------------------------}
procedure TcxCustomTRichViewEdit.InitializeInnerEdit;
begin
  inherited;
  TcxCustomTRichViewEdit(InnerEdit.Control).ParentShowHint := True;
end;

{------------------------------------------------------------------------------}
procedure TcxCustomTRichViewEdit.WndProc(var Message: TMessage);
begin
  inherited WndProc(Message);
  case Message.Msg of
    WM_NCCALCSIZE, WM_WINDOWPOSCHANGED, CM_WININICHANGE:
      UpdateScrollBarsParameters;
  end;
end;

{------------------------------------------------------------------------------}
function TcxCustomTRichViewEdit.DoShowPopupMenu(AMenu: TComponent;
  X, Y: Integer): Boolean;
begin
  if Assigned(AMenu) then
    Result := inherited DoShowPopupMenu(AMenu, X, Y)
  else
  begin
    UpdateEditPopupMenuItems(GetEditPopupMenuInstance);
    Result := inherited DoShowPopupMenu(GetEditPopupMenuInstance, X, Y);
    EditingChanged;
  end;
end;

{------------------------------------------------------------------------------}
function TcxCustomTRichViewEdit.GetEditPopupMenuInstance: TComponent;
  function NewItem(const ACaption: string; ATag: Integer): TMenuItem;
  begin
    Result := TMenuItem.Create(Self);
    with Result do
    begin
      Caption := ACaption;
      Tag := ATag;
      OnClick := EditPopupMenuClick;
    end;
  end;

var
  APopupMenu: TPopupMenu;
begin
  if Assigned(FEditPopupMenu) then
  begin
    Result := FEditPopupMenu;
    exit;
  end;
  APopupMenu := TPopupMenu.Create(Self);
  FEditPopupMenu := APopupMenu;
  APopupMenu.Items.Add
    (NewItem(cxGetResourceString(@cxSEditRichEditUndoCaption), -1));
  APopupMenu.Items.Add
    (NewItem(cxGetResourceString(@cxSEditRichEditRedoCaption), -2));
  APopupMenu.Items.Add(NewItem('-', MaxInt));
  APopupMenu.Items.Add
    (NewItem(cxGetResourceString(@cxSEditRichEditCutCaption), -3));
  APopupMenu.Items.Add
    (NewItem(cxGetResourceString(@cxSEditRichEditCopyCaption), -4));
  APopupMenu.Items.Add
    (NewItem(cxGetResourceString(@cxSEditRichEditPasteCaption), -5));
  APopupMenu.Items.Add
    (NewItem(cxGetResourceString(@cxSEditRichEditDeleteCaption), -6));
  APopupMenu.Items.Add(NewItem('-', MaxInt));
  APopupMenu.Items.Add
    (NewItem(cxGetResourceString(@cxSEditRichEditSelectAllCaption), -7));
  Result := APopupMenu;
end;

{------------------------------------------------------------------------------}
procedure TcxCustomTRichViewEdit.EditPopupMenuClick(Sender: TObject);
begin
  case Integer(TMenuItem(Sender).Tag) of
    - 1:
      InnerEditor.Undo;
    -2:
      InnerEditor.Redo;
    -3:
      InnerEditor.CutDef;
    -4:
      InnerEditor.CopyDef;
    -5:
      InnerEditor.Paste;
    -6:
      InnerEditor.DeleteSelection;
    -7:
      InnerEditor.SelectAll;
  end;
end;

{------------------------------------------------------------------------------}
procedure TcxCustomTRichViewEdit.UpdateEditPopupMenuItems
  (APopupMenu: TComponent);

  procedure UpdateItems(APopupMenu: TPopupMenu);
  begin
    APopupMenu.Items[0].Enabled := InnerEditor.UndoAction <> rvutNone;
    APopupMenu.Items[1].Enabled := InnerEditor.RedoAction <> rvutNone;
    APopupMenu.Items[3].Enabled := InnerEditor.CanDelete;
    APopupMenu.Items[4].Enabled := InnerEditor.SelectionExists;
    APopupMenu.Items[5].Enabled := InnerEditor.CanPaste;
    APopupMenu.Items[6].Enabled := InnerEditor.CanDelete;
    APopupMenu.Items[8].Enabled := True;
  end;

begin
  if not(APopupMenu is TPopupMenu) then
    exit;
  // InnerRich.ReadOnly := not DataBinding.CanModify or ActiveProperties.ReadOnly;
  UpdateItems(TPopupMenu(APopupMenu));
  // InnerRich.ReadOnly := RealReadOnly; // !!! ReadOnly must be True in DBRichEdit while DataSet is not in EditMode (for AddictSpellChecker)
end;

{------------------------------------------------------------------------------}
function TcxCustomTRichViewEdit.SupportsSpelling: Boolean;
begin
  Result := True;
end;

{================================ TcxTRichViewEdit ================================}
function TcxTRichViewEdit.GetActiveProperties: TcxRVProperties;
begin
  Result := TcxRVProperties(InternalGetActiveProperties);
end;

{------------------------------------------------------------------------------}
function TcxTRichViewEdit.GetProperties: TcxRVProperties;
begin
  Result := TcxRVProperties(FProperties);
end;

{------------------------------------------------------------------------------}
class function TcxTRichViewEdit.GetPropertiesClass
  : TcxCustomEditPropertiesClass;
begin
  Result := TcxRVProperties;
end;

{------------------------------------------------------------------------------}
procedure TcxTRichViewEdit.SetProperties(Value: TcxRVProperties);
begin
  FProperties.Assign(Value);
end;

{=============================== TcxRVData ====================================}

function TcxRVData.GetCxEditor: TcxCustomTRichViewEdit;
begin
  Result := (RichView as TcxInnerTRichViewEdit).Container;
end;
{------------------------------------------------------------------------------}
function TcxRVData.IsAssignedOnCopy: Boolean;
var
  Editor: TcxCustomTRichViewEdit;
begin
  Editor := GetCxEditor;
  Result := Assigned(Editor.Properties.OnCopy) or
    ((Editor.RepositoryItem <> nil) and Assigned(Editor.ActiveProperties.OnCopy));
end;
{------------------------------------------------------------------------------}
function TcxRVData.IsAssignedOnProgress: Boolean;
var
  Editor: TcxCustomTRichViewEdit;
begin
  Editor := GetCxEditor;
  Result := Assigned(Editor.Properties.OnProgress) or
    ((Editor.RepositoryItem <> nil) and Assigned(Editor.ActiveProperties.OnProgress));
end;
{------------------------------------------------------------------------------}
function TcxRVData.IsAssignedOnReadHyperlink: Boolean;
var
  Editor: TcxCustomTRichViewEdit;
begin
  Editor := GetCxEditor;
  Result := Assigned(Editor.Properties.OnReadHyperlink) or
    ((Editor.RepositoryItem <> nil) and Assigned(Editor.ActiveProperties.OnReadHyperlink));
end;
{------------------------------------------------------------------------------}
function TcxRVData.IsAssignedOnWriteHyperlink: Boolean;
var
  Editor: TcxCustomTRichViewEdit;
begin
  Editor := GetCxEditor;
  Result := Assigned(Editor.Properties.OnWriteHyperlink) or
    ((Editor.RepositoryItem <> nil) and Assigned(Editor.ActiveProperties.OnWriteHyperlink));
end;

initialization

  GetRegisteredEditProperties.Register(TcxRVProperties, scxSEditRepositoryRVItem);

end.
