unit cxTRichViewRepositoryItems;

interface

uses
  Classes, cxEdit, cxTRichView;

type
  TcxEditRepositoryRVItem = class(TcxEditRepositoryItem)
  private
    function GetProperties: TcxRVProperties;
    procedure SetProperties(Value: TcxRVProperties);
  public
    class function GetEditPropertiesClass
      : TcxCustomEditPropertiesClass; override;
  published
    property Properties: TcxRVProperties read GetProperties write SetProperties;
  end;

implementation

{=============================== TcxEditRepositoryRVItem ======================}
class function TcxEditRepositoryRVItem.GetEditPropertiesClass
  : TcxCustomEditPropertiesClass;
begin
  Result := TcxRVProperties;
end;

{------------------------------------------------------------------------------}
function TcxEditRepositoryRVItem.GetProperties: TcxRVProperties;
begin
  Result := inherited Properties as TcxRVProperties;
end;

{------------------------------------------------------------------------------}
procedure TcxEditRepositoryRVItem.SetProperties(Value: TcxRVProperties);
begin
  inherited Properties := Value;
end;

{==============================================================================}
initialization

RegisterClass(TcxEditRepositoryRVItem);

finalization

UnRegisterClass(TcxEditRepositoryRVItem);

end.
