
{*******************************************************}
{                                                       }
{       Demo: Collapsible sections using hidden text    }
{                                                       }
{       Copyright (c) Sergey Tkachenko                  }
{       svt@trichview.com                               }
{       http://www.trichview.com                        }
{                                                       }
{*******************************************************}

unit Unit1;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms,
  Dialogs, ImgList, ComCtrls, RVStyle, RVScroll, RichView, RVTypes, RVItem,
  CRVFData;

type
  TForm1 = class(TForm)
    ImageList1: TImageList;
    RVStyle1: TRVStyle;
    rv: TRichView;
    procedure FormCreate(Sender: TObject);
    procedure rvJump(Sender: TObject; id: Integer);
    function IsExpanded(rv: TCustomRichView; ItemNo: Integer): Boolean;
    procedure ChangeExpanded(rv: TCustomRichView; ItemNo: Integer);
  private
    { Private declarations }
    procedure CreateDoc;
    procedure ExpandAndCollapse;
  public
    { Public declarations }

  end;

var
  Form1: TForm1;

implementation

{$R *.dfm}

{ TForm1 }

{ Creating a document.
  Important: "hotspots" start paragraphs. They are followed by hypertext text
  items. All "hotspots" have unique text ("id1", "id2", ...).
  Hotspot's image index = 1 means "expanded", = 0 means "collapsed".
}
procedure TForm1.CreateDoc;
begin
   rv.AddHotspot('id1', 1, 1, ImageList1, 1);
   rv.AddNL('Topic 1', 1, -1);
   rv.AddNL('Bla-bla-bla. Bla-bla-bla. Bla-bla-bla. Bla-bla-bla.', 0, 0);
   rv.AddNL('Bla-bla-bla. Bla-bla-bla. Bla-bla-bla. Bla-bla-bla.', 0, 0);

   rv.AddHotspot('id2', 1, 1, ImageList1, 1);
   rv.AddNL('Topic 2', 1, -1);
   rv.AddNL('Bla-bla-bla. Bla-bla-bla. Bla-bla-bla. Bla-bla-bla.', 0, 0);
   rv.AddNL('Bla-bla-bla. Bla-bla-bla. Bla-bla-bla. Bla-bla-bla.', 0, 0);

   rv.AddHotspot('id3', 1, 1, ImageList1, 1);
   rv.AddNL('Topic 3', 1, -1);
   rv.AddNL('Bla-bla-bla. Bla-bla-bla. Bla-bla-bla. Bla-bla-bla.', 0, 0);
   rv.AddNL('Bla-bla-bla. Bla-bla-bla. Bla-bla-bla. Bla-bla-bla.', 0, 0);

   rv.AddHotspot('id4', 1, 1, ImageList1, 1);
   rv.AddNL('Topic 4', 1, -1);
   rv.AddNL('Bla-bla-bla. Bla-bla-bla. Bla-bla-bla. Bla-bla-bla.', 0, 0);
   rv.AddNL('Bla-bla-bla. Bla-bla-bla. Bla-bla-bla. Bla-bla-bla.', 0, 0);
   rv.Format;
end;
{------------------------------------------------------------------------------}
{
 This function returns the index hidden/visible text style for the given StyleNo.

 The result is the index of an item in RVStyle.TextStyles having all properties
 like RVStyle.TextStyles[StyleNo], but hidden/visible depending on Hidden
 parameter.
 If such a text style does not exist, it is added.

 Note: in this demo, we could simply use fixed indices (0 for visible text,
  2 for hidden text). But this function is made universal.
}
function GetHiddenOrVisibleStyleNo(RVStyle: TRVStyle; StyleNo: Integer;
  Hidden: Boolean): Integer;
var CurTextStyle, TextStyle: TFontInfo;
begin
  // optimization: if the StyleNo-th text style is already hidden/visible like
  // we need, returning StyleNo
  CurTextStyle := RVStyle.TextStyles[StyleNo];
  if (rvteoHidden in CurTextStyle.Options)=Hidden then
  begin
    Result := StyleNo;
    exit;
  end;
  // otherwise, finding the desired style
  TextStyle := TFontInfo.Create(nil);
  try
    TextStyle.Assign(CurTextStyle);
    if Hidden then
      TextStyle.Options := TextStyle.Options+[rvteoHidden]
    else
      TextStyle.Options := TextStyle.Options-[rvteoHidden];
    Result := RVStyle.FindTextStyle(TextStyle);
  finally
    TextStyle.Free;
  end;
end;
{------------------------------------------------------------------------------}
{
 Makes the specified range of items hidden or visible.

 Note: it works both for text and non-text items. This demo does not show/hide
   non-text items, but this procedure is made universal.
}
procedure HideOrShowRange(rv: TCustomRichView; FirstItemNo, LastItemNo: Integer;
  Hide: Boolean);
var i: Integer;
begin
  for i := FirstItemNo to LastItemNo do
    if rv.GetItemStyle(i)>=0 then
      rv.GetItem(i).StyleNo := GetHiddenOrVisibleStyleNo(rv.Style, rv.GetItemStyle(i), Hide)
    else
      rv.SetItemExtraIntProperty(i, rvepHidden, ord(Hide));
end;
{------------------------------------------------------------------------------}
{
  Hides/shows items depending on the state of hotspots
}
procedure TForm1.ExpandAndCollapse;
var i: Integer;
    NextHeadingItemNo, NextParaItemNo: Integer;
begin
  NextHeadingItemNo := rv.ItemCount;
  NextParaItemNo    := rv.ItemCount;
  for i := rv.ItemCount-1 downto 0 do
    if rv.IsParaStart(i) then
    begin
      if (rv.GetItemStyle(i) = rvsHotspot) then
      begin
          HideOrShowRange(rv, NextParaItemNo, NextHeadingItemNo-1, not IsExpanded(rv, i));
        NextHeadingItemNo := i;
      end;
      NextParaItemNo := i;
    end;
  rv.Format;
end;
{------------------------------------------------------------------------------}
procedure TForm1.FormCreate(Sender: TObject);
begin
  CreateDoc;
end;
{------------------------------------------------------------------------------}
{ Clicking hyperlink }
procedure TForm1.rvJump(Sender: TObject; id: Integer);
var
  RVData: TCustomRVFormattedData;
  ItemNo: Integer;
begin
  rv.GetJumpPointLocation(id, RVData, ItemNo);
  if RVData.GetItemStyle(ItemNo)<>rvsHotspot then
    dec(ItemNo); // Clicked on text. We assume that hypertext is just after hotspots
  // Changing the hotspot state
  ChangeExpanded(rv, ItemNo);
  // Updating the document accordingly
  ExpandAndCollapse;
  // Possible optimization: in this demo, we ExpandAndCollapse updates the whole
  // document. You can change it to update only the clicked section (started from ItemNo)
end;
{------------------------------------------------------------------------------}
{ Checking the ItemNo-th item in rv. This item must be a "hotspot".
  If ImageIndex=0, it is "collapsed"
  If ImageIndex=1, it is "expanded"
}
function TForm1.IsExpanded(rv: TCustomRichView; ItemNo: Integer): Boolean;
var
  ImageIndex1,ImageIndex2: Integer;
  Tag: TRVTag;
  Text: TRVUnicodeString;
  il: TCustomImageList;
begin
  rv.GetHotspotInfo(ItemNo, Text, ImageIndex1, ImageIndex2, il, Tag);
  Result := ImageIndex1<>0;
end;
{------------------------------------------------------------------------------}
{ Changing image index the ItemNo-th item in rv (This item must be a "hotspot").
  1 <-> 0
}
procedure TForm1.ChangeExpanded(rv: TCustomRichView; ItemNo: Integer);
var
  ImageIndex1,ImageIndex2: Integer;
  Tag: TRVTag;
  Text: TRVUnicodeString;
  il: TCustomImageList;
begin
  rv.GetHotspotInfo(ItemNo, Text, ImageIndex1, ImageIndex2, il, Tag);
  if ImageIndex1=0 then
    ImageIndex1 := 1
  else
    ImageIndex1 := 0;
  rv.SetHotspotInfo(ItemNo, Text, ImageIndex1, ImageIndex1, il, Tag);
end;
{------------------------------------------------------------------------------}

end.
