{*******************************************************}
{                                                       }
{       RichView                                        }
{       Demo: how to resize and drag&drop inserted      }
{       controls.                                       }
{                                                       }
{       Copyright (c) Sergey Tkachenko                  }
{       svt@trichview.com                               }
{       http://www.trichview.com                        }
{                                                       }
{*******************************************************}

unit Unit1;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, RVStyle, RVScroll, RichView, RVEdit, RVItem;

type
  TForm1 = class(TForm)
    rve: TRichViewEdit;
    RVStyle1: TRVStyle;
    Button1: TButton;
    procedure FormCreate(Sender: TObject);
    procedure rveControlAction(Sender: TCustomRichView;
      ControlAction: TRVControlAction; ItemNo: Integer;
      var ctrl: TControl);
    procedure Button1Click(Sender: TObject);
  private
    { Private declarations }
    ClickedControl: TObject;
    ClickPoint: TPoint;
    procedure ButtonClick(Sender: TObject);
    procedure ControlMouseDown(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);
    procedure ControlMouseMove(Sender: TObject;
      Shift: TShiftState; X, Y: Integer);
    procedure GenerateDoc;
    function CreateButton(const Caption: String; OnClick: TNotifyEvent): TButton;
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

{$R *.DFM}

{------------------------------------------------------------------------------}
procedure TForm1.FormCreate(Sender: TObject);
begin
  GenerateDoc;
end;
{------------------------------------------------------------------------------}
// Generating the initial document
procedure TForm1.GenerateDoc;
var btn: TButton;
begin
  rve.Clear;
  rve.AddNL('Demo',1, 1);
  rve.AddNL('Insert a ', 0, 0);
  btn := CreateButton('Button', ButtonClick);
  rve.AddControlEx('', btn, -1, rvvaBaseLine);
  rve.SetItemExtraIntProperty(rve.ItemCount-1, rvepResizable, 1);
  rve.AddNL(' and drag&drop it across this window.', 0, -1);
  rve.Format;
end;
{------------------------------------------------------------------------------}
// Creating a button for insertion in TRichViewEdit
function TForm1.CreateButton(const Caption: String;
  OnClick: TNotifyEvent): TButton;
begin
  Result := TButton.Create(nil);
  Result.Caption := Caption;
  Result.Font.Name := 'Tahoma';
  Result.OnClick := OnClick;
  Result.OnMouseDown := ControlMouseDown;
  Result.OnMouseMove := ControlMouseMove;
end;
{------------------------------------------------------------------------------}
// Inserting a new button
procedure TForm1.Button1Click(Sender: TObject);
var btn: TButton;
begin
  btn := CreateButton('Button', OnClick);
  rve.TopLevelEditor.BeginUndoGroup(rvutInsert);
  rve.TopLevelEditor.SetUndoGroupMode(True);
  try
    if rve.InsertControl('', btn, rvvaBaseline) then
      rve.SetCurrentItemExtraIntProperty(rvepResizable, 1, True);
  finally
    rve.TopLevelEditor.SetUndoGroupMode(False);
  end;
end;
{------------------------------------------------------------------------------}
// This procedure is assigned to OnMouseDown of all inserted buttons
procedure TForm1.ControlMouseDown(Sender: TObject; Button: TMouseButton;
  Shift: TShiftState; X, Y: Integer);
begin
  if Button = mbLeft then begin
    rve.SelectControl(TControl(Sender));
    ClickedControl := Sender;
    ClickPoint := Point(X, Y);
  end;
end;
{------------------------------------------------------------------------------}
// This procedure is assigned to OnMouseMove of all inserted buttons
procedure TForm1.ControlMouseMove(Sender: TObject; Shift: TShiftState; X, Y: Integer);
begin
  if (ssLeft in Shift) and (ClickedControl=Sender) and
    (Sqr(ClickPoint.X-X)+Sqr(ClickPoint.Y-Y)>10) then
    rve.BeginOleDrag;
end;
{------------------------------------------------------------------------------}
// This procedure is assigned to OnClick of all inserted buttons
procedure TForm1.ButtonClick(Sender: TObject);
begin
  Application.MessageBox('You click, I appear', 'Message', MB_OK or MB_ICONINFORMATION);
end;
{------------------------------------------------------------------------------}
// rve.OnControlAction: reassigning all events of loaded controls
procedure TForm1.rveControlAction(Sender: TCustomRichView;
  ControlAction: TRVControlAction; ItemNo: Integer; var ctrl: TControl);
begin
 if (ControlAction=rvcaAfterRVFLoad) then begin
   if ctrl is TButton then begin
     TButton(ctrl).OnMouseDown := ControlMouseDown;
     TButton(ctrl).OnMouseMove := ControlMouseMove;
     TButton(ctrl).OnClick := ButtonClick;
   end;
 end;
end;

initialization
  // classes of all controls must be registered before loading them from RVF
  // (copy-pasting and drag&drop also involve RVF loading)
  RegisterClass(TButton);

end.
