
{*******************************************************}
{                                                       }
{       RichView                                        }
{       Demo: using external scrollbars                 }
{                                                       }
{       Copyright (c) Sergey Tkachenko                  }
{       svt@trichview.com                               }
{       http://www.trichview.com                        }
{                                                       }
{*******************************************************}


unit main;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  Menus, RVStyle, RVScroll, RichView, StdCtrls;

type
  TScrollForm = class(TForm)
    HorizScrollBar: TScrollBar;
    VertScrollBar: TScrollBar;
    ScrollRVStyle: TRVStyle;
    ScrollRichView: TRichView;
    MainMenu1: TMainMenu;
    RVFOpenDialog: TOpenDialog;
    MenuFile: TMenuItem;
    FileOpen: TMenuItem;
    procedure FormCreate(Sender: TObject);
    procedure HorizScrollBarScroll(Sender: TObject;
      ScrollCode: TScrollCode; var ScrollPos: Integer);
    procedure VertScrollBarScroll(Sender: TObject; ScrollCode: TScrollCode;
      var ScrollPos: Integer);
    procedure ScrollRichViewVScrolled(Sender: TObject);
    procedure ScrollRichViewHScrolled(Sender: TObject);
    procedure FileOpenClick(Sender: TObject);
    procedure ScrollRichViewResize(Sender: TObject);
  private
    procedure ScrollAdjust;
  public
  end;

var
  ScrollForm: TScrollForm;

implementation

{$R *.DFM}

procedure TScrollForm.FormCreate(Sender: TObject);
begin
  ScrollAdjust;
end;

procedure TScrollForm.ScrollAdjust;
var PageSize: Integer;
begin
  VertScrollBar.PageSize := 0;
  if ScrollRichView.VScrollMax>0 then begin
    PageSize := ScrollRichView.ClientHeight div ScrollRichView.VSmallStep;
    VertScrollBar.Max := ScrollRichView.VScrollMax+PageSize-1;
    VertScrollBar.PageSize := PageSize;
    end
  else begin
    VertScrollBar.Max := 0;
  end;
  VertScrollBar.Position := ScrollRichView.VScrollPos;
  VertScrollBar.Visible := VertScrollBar.Max>0;
  HorizScrollBar.PageSize := 0;
  if ScrollRichView.HScrollMax>0 then begin
    PageSize := ScrollRichView.ClientWidth;
    HorizScrollBar.Max := ScrollRichView.HScrollMax+PageSize-1;
    HorizScrollBar.PageSize := PageSize;
    end
  else begin
    HorizScrollBar.Max := 0;
  end;
  HorizScrollBar.Position := ScrollRichView.HScrollPos;
  HorizScrollBar.Visible := HorizScrollBar.Max>0;
end;

procedure TScrollForm.ScrollRichViewResize(Sender: TObject);
begin
  ScrollAdjust;
end;

procedure TScrollForm.HorizScrollBarScroll(Sender: TObject;
  ScrollCode: TScrollCode; var ScrollPos: Integer);
begin
  ScrollRichView.HScrollPos := HorizScrollBar.Position;
end;

procedure TScrollForm.VertScrollBarScroll(Sender: TObject;
  ScrollCode: TScrollCode; var ScrollPos: Integer);
begin
  ScrollRichView.VScrollPos := VertScrollBar.Position;
end;

procedure TScrollForm.ScrollRichViewVScrolled(Sender: TObject);
begin
  VertScrollBar.Position := ScrollRichView.VScrollPos;
end;

procedure TScrollForm.ScrollRichViewHScrolled(Sender: TObject);
begin
  HorizScrollBar.Position := ScrollRichView.HScrollPos;
end;

procedure TScrollForm.FileOpenClick(Sender: TObject);
begin
  if RVFOpenDialog.Execute then begin
    with ScrollRichView do begin
      LoadRVF(RVFOpenDialog.FileName);
      Format;
      VScrollPos := 0;
      HScrollPos := 0;
      ScrollAdjust;
    end;
  end;
end;

end.

